/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.controlmode.helpers;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;

public class TableControlModeHelper {
    public static Iterable<EObject> createDescendantTablesIterable(EObject context) {
        HashSet result = Sets.newHashSet();
        TreeIterator eAllContents = EcoreUtil.getAllProperContents((EObject)context, (boolean)true);
        Iterator contextAndDescendants = Iterators.concat((Iterator)eAllContents, (Iterator)Iterators.singletonIterator((Object)context));
        Predicate<EStructuralFeature.Setting> keepTableInstances = new Predicate<EStructuralFeature.Setting>(){

            public boolean apply(EStructuralFeature.Setting setting) {
                boolean result = true;
                if (setting != null) {
                    EObject settingEObject = setting.getEObject();
                    result &= settingEObject instanceof Table;
                } else {
                    result = false;
                }
                return result;
            }
        };
        Function<EStructuralFeature.Setting, EObject> getEObject = new Function<EStructuralFeature.Setting, EObject>(){

            public EObject apply(EStructuralFeature.Setting input) {
                EObject settingEObject = input.getEObject();
                return settingEObject;
            }
        };
        while (contextAndDescendants.hasNext()) {
            EObject current = (EObject)contextAndDescendants.next();
            Collection usages = EMFHelper.getUsages((EObject)current);
            Iterable tableInstanceSettings = Iterables.filter((Iterable)usages, (Predicate)keepTableInstances);
            Iterable papyrusTableInstances = Iterables.transform((Iterable)tableInstanceSettings, (Function)getEObject);
            Iterables.addAll((Collection)result, (Iterable)papyrusTableInstances);
        }
        return result;
    }
}

