/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.editpolicies;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editpolicies.ConstrainedLayoutEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;

public abstract class XYLayoutEditPolicy
extends ConstrainedLayoutEditPolicy {
    private static final Dimension PREFERRED_SIZE = new Dimension(-1, -1);
    private XYLayout xyLayout;

    @Override
    protected Object getConstraintFor(Request request, GraphicalEditPart child, Rectangle rect) {
        if (request instanceof ChangeBoundsRequest) {
            if (((ChangeBoundsRequest)request).getSizeDelta().width == 0 && ((ChangeBoundsRequest)request).getSizeDelta().height == 0) {
                if (this.getCurrentConstraintFor(child) != null) {
                    rect.setSize(this.getCurrentConstraintFor(child).getSize());
                }
            } else {
                rect.setSize(Dimension.max((Dimension)this.getMinimumSizeFor(child), (Dimension)rect.getSize()));
            }
        }
        return super.getConstraintFor(request, child, rect);
    }

    @Override
    public Object getConstraintFor(Point p) {
        return new Rectangle(p, PREFERRED_SIZE);
    }

    @Override
    public Object getConstraintFor(Rectangle r) {
        return new Rectangle(r);
    }

    protected Rectangle getCurrentConstraintFor(GraphicalEditPart child) {
        IFigure fig = child.getFigure();
        return (Rectangle)fig.getParent().getLayoutManager().getConstraint(fig);
    }

    @Override
    protected Point getLayoutOrigin() {
        return this.getXYLayout().getOrigin(this.getLayoutContainer());
    }

    protected XYLayout getXYLayout() {
        if (this.xyLayout == null) {
            IFigure container = this.getLayoutContainer();
            this.xyLayout = (XYLayout)container.getLayoutManager();
        }
        return this.xyLayout;
    }

    public void setXyLayout(XYLayout xyLayout) {
        this.xyLayout = xyLayout;
    }

    @Override
    protected void showSizeOnDropFeedback(CreateRequest request) {
        Point p = new Point(request.getLocation().getCopy());
        Dimension size = request.getSize().getCopy();
        Rectangle feedbackBounds = new Rectangle(p, size);
        IFigure feedback = this.getSizeOnDropFeedback(request);
        feedback.translateToRelative((Translatable)feedbackBounds);
        feedback.setBounds(feedbackBounds.expand(this.getCreationFeedbackOffset(request)));
        feedback.validate();
    }

    protected Dimension getMinimumSizeFor(GraphicalEditPart child) {
        return new Dimension(8, 8);
    }
}

