/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.jeview.views;

import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.jeview.views.Error;
import org.eclipse.jdt.jeview.views.JEAttribute;
import org.eclipse.jdt.jeview.views.JEMarker;
import org.eclipse.jdt.jeview.views.JavaElement;
import org.eclipse.jdt.jeview.views.JavaElementChildrenProperty;
import org.eclipse.jdt.jeview.views.JavaElementProperty;
import org.eclipse.jdt.jeview.views.Null;

public class JEResource
extends JEAttribute {
    private final JEAttribute fParent;
    private final String fName;
    private IResource fResource;

    JEResource(JEAttribute parent, String name, IResource resource) {
        Assert.isNotNull((Object)resource);
        this.fParent = parent;
        this.fName = name;
        this.fResource = resource;
    }

    @Override
    public JEAttribute getParent() {
        return this.fParent;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        JEResource other = (JEResource)obj;
        if (!Objects.equals(this.fParent, other.fParent)) {
            return false;
        }
        return Objects.equals(this.fName, other.fName);
    }

    @Override
    public int hashCode() {
        return (this.fParent != null ? this.fParent.hashCode() : 0) + (this.fName != null ? this.fName.hashCode() : 0) + this.fResource.hashCode();
    }

    @Override
    public Object getWrappedObject() {
        return this.fResource;
    }

    public IResource getResource() {
        return this.fResource;
    }

    @Override
    public JEAttribute[] getChildren() {
        ArrayList<JEAttribute> result = new ArrayList<JEAttribute>();
        IContainer parent = this.fResource.getParent();
        if (parent != null) {
            result.add(new JEResource(this, "PARENT", (IResource)parent));
        } else {
            result.add(new JavaElementProperty(this, "PARENT", parent));
        }
        result.add(new JavaElement(this, "JavaCore.create(..)", JavaCore.create((IResource)this.fResource)));
        if (this.fResource instanceof IContainer) {
            final IContainer container = (IContainer)this.fResource;
            result.add(new JavaElementChildrenProperty(this, "MEMBERS"){

                @Override
                protected JEAttribute[] computeChildren() throws CoreException {
                    IResource[] resources = container.members();
                    JEAttribute[] children = new JEAttribute[resources.length];
                    int i = 0;
                    while (i < resources.length) {
                        children[i] = new JEResource(this, null, resources[i]);
                        ++i;
                    }
                    return children;
                }
            });
        }
        result.add(new JavaElementChildrenProperty(this, "FIND MARKERS (DEPTH_ZERO)"){

            @Override
            protected JEAttribute[] computeChildren() throws CoreException {
                IMarker[] markers = JEResource.this.getResource().findMarkers(null, true, 0);
                JEAttribute[] children = new JEAttribute[markers.length];
                int i = 0;
                while (i < markers.length) {
                    children[i] = new JEMarker(this, "[" + i + "]", markers[i]);
                    ++i;
                }
                return children;
            }
        });
        result.add(new JavaElementChildrenProperty(this, "PERSISTENT PROPERTIES"){

            @Override
            protected JEAttribute[] computeChildren() throws CoreException {
                Map properties = JEResource.this.getResource().getPersistentProperties();
                JEAttribute[] children = new JEAttribute[properties.size()];
                int i = 0;
                for (Map.Entry property : properties.entrySet()) {
                    children[i] = new JavaElementProperty(this, ((QualifiedName)property.getKey()).toString(), property.getValue());
                    ++i;
                }
                return children;
            }
        });
        result.add(new JavaElementChildrenProperty(this, "SESSION PROPERTIES"){

            @Override
            protected JEAttribute[] computeChildren() throws CoreException {
                Map properties = JEResource.this.getResource().getSessionProperties();
                JEAttribute[] children = new JEAttribute[properties.size()];
                int i = 0;
                for (Map.Entry property : properties.entrySet()) {
                    children[i] = new JavaElementProperty(this, ((QualifiedName)property.getKey()).toString(), property.getValue());
                    ++i;
                }
                return children;
            }
        });
        return result.toArray(new JEAttribute[result.size()]);
    }

    @Override
    public String getLabel() {
        String label = this.fResource.getName();
        if (this.fName != null) {
            label = String.valueOf(this.fName) + ": " + label;
        }
        if (!this.fResource.exists()) {
            label = String.valueOf(label) + " (does not exist)";
        }
        return label;
    }

    public static JEAttribute compute(JEAttribute parent, String name, Callable<IResource> computer) {
        try {
            IResource resource = computer.call();
            return JEResource.create(parent, name, resource);
        }
        catch (Exception e) {
            return new Error(parent, name, e);
        }
    }

    public static JEAttribute create(JEAttribute parent, String name, IResource resource) {
        if (resource == null) {
            return new Null(parent, name);
        }
        return new JEResource(parent, name, resource);
    }
}

