/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.core.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.core.internal.DiagramPlugin;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.Diagram;

public class CreateDiagramCommand
extends AbstractTransactionalCommand {
    private final String _diagramType;
    private EObject _semanticContext;
    private PreferencesHint _preferencesHint;

    public CreateDiagramCommand(TransactionalEditingDomain editingDomain, String label, EObject anElementContext, String aDiagramKindType, PreferencesHint preferencesHint) {
        super(editingDomain, label, null);
        assert (anElementContext != null) : "Null element context in CreateDiagramCommand";
        this._semanticContext = anElementContext;
        this._diagramType = aDiagramKindType;
        this._preferencesHint = preferencesHint;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        Diagram diagram = ViewService.getInstance().createDiagram((IAdaptable)new EObjectAdapter(this.getSemanticContext()), this.getDiagramType(), this.getPreferencesHint());
        int severity = 0;
        if (diagram == null) {
            severity = 4;
        }
        return new CommandResult((IStatus)new Status(severity, this.getPluginId(), 0, "", null), (Object)diagram);
    }

    protected String getPluginId() {
        return DiagramPlugin.getPluginId();
    }

    protected String getDiagramType() {
        return this._diagramType;
    }

    protected EObject getSemanticContext() {
        return this._semanticContext;
    }

    protected PreferencesHint getPreferencesHint() {
        return this._preferencesHint;
    }
}

