/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.manager.axis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.infra.nattable.manager.axis.AbstractTreeAxisManagerForEventList;
import org.eclipse.papyrus.infra.nattable.manager.axis.IAxisManager;
import org.eclipse.papyrus.infra.nattable.manager.axis.ICompositeAxisManager;
import org.eclipse.papyrus.infra.nattable.manager.cell.CellManagerFactory;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.IAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.ITreeItemAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.AxisManagerRepresentation;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.TreeFillingConfiguration;
import org.eclipse.papyrus.infra.nattable.utils.FillingConfigurationUtils;
import org.eclipse.papyrus.infra.nattable.utils.TableHelper;

public class ITreeItemAxisComparator
implements Comparator<ITreeItemAxis> {
    private INattableModelManager manager;
    private IAxisManager axisManager;

    public ITreeItemAxisComparator(INattableModelManager tableManager) {
        this(tableManager, null);
    }

    public ITreeItemAxisComparator(INattableModelManager tableManager, AbstractTreeAxisManagerForEventList axisManager) {
        this.manager = tableManager;
        this.axisManager = axisManager;
    }

    private int compareObjectWithDifferentParent(ITreeItemAxis axis1, ITreeItemAxis axis2) {
        ITreeItemAxis parent2;
        ITreeItemAxis parent1 = axis1.getParent();
        Assert.isTrue((parent1 != (parent2 = axis2.getParent()) ? 1 : 0) != 0);
        ArrayList<ITreeItemAxis> path1 = new ArrayList<ITreeItemAxis>();
        ArrayList<ITreeItemAxis> path2 = new ArrayList<ITreeItemAxis>();
        TableHelper.getPath(path1, axis1);
        TableHelper.getPath(path2, axis2);
        if (path1.size() == path2.size()) {
            int indexToCompare = path1.size() - 1;
            return this.compare((ITreeItemAxis)path1.get(--indexToCompare), (ITreeItemAxis)path2.get(indexToCompare));
        }
        ITreeItemAxis firstCommon = null;
        for (ITreeItemAxis current : path1) {
            if (!path2.contains(current)) continue;
            firstCommon = current;
            break;
        }
        if (firstCommon != null && path1 != null && !path1.isEmpty() && !firstCommon.equals(path1.get(path1.size() - 1))) {
            int index1 = path1.indexOf(firstCommon);
            int index2 = path2.indexOf(firstCommon);
            return this.compare((ITreeItemAxis)path1.get(index1++), (ITreeItemAxis)path2.get(index2++));
        }
        return 0;
    }

    protected AxisManagerRepresentation getAxisManagerRepresentation(ITreeItemAxis axis1, ITreeItemAxis axis2) {
        if (this.axisManager != null) {
            return this.axisManager.getAxisManagerRepresentation();
        }
        IAxisManager axisManager = this.manager.getRowAxisManager();
        Assert.isTrue((boolean)(axisManager instanceof ICompositeAxisManager));
        IAxisManager subAxisManager1 = ((ICompositeAxisManager)axisManager).getSubAxisManagerFor((IAxis)axis1);
        IAxisManager subAxisManager2 = ((ICompositeAxisManager)axisManager).getSubAxisManagerFor((IAxis)axis2);
        if ((subAxisManager1 != null || subAxisManager2 != null) && subAxisManager1 != subAxisManager2) {
            throw new UnsupportedOperationException("this case is not yet supported");
        }
        if (subAxisManager1 != null) {
            return subAxisManager1.getAxisManagerRepresentation();
        }
        throw new UnsupportedOperationException("this case is not yet supported");
    }

    @Override
    public int compare(ITreeItemAxis axis1, ITreeItemAxis axis2) {
        int index2;
        int index1;
        if (axis1 == axis2) {
            return 0;
        }
        if (axis1.getParent() != axis2.getParent()) {
            return this.compareObjectWithDifferentParent(axis1, axis2);
        }
        Object el1 = axis1.getElement();
        Object el2 = axis2.getElement();
        if (el1 instanceof TreeFillingConfiguration) {
            Assert.isTrue((boolean)(el2 instanceof TreeFillingConfiguration));
            int depth1 = ((TreeFillingConfiguration)el1).getDepth();
            int depth2 = ((TreeFillingConfiguration)el2).getDepth();
            if (depth1 != depth2) {
                throw new UnsupportedOperationException("Please fill a bug with your example");
            }
            List<TreeFillingConfiguration> confs = FillingConfigurationUtils.getTreeFillingConfiguration(this.manager.getTable(), this.getAxisManagerRepresentation(axis1, axis2));
            index1 = confs.indexOf(el1);
            index2 = confs.indexOf(el2);
        } else {
            ITreeItemAxis parent1 = axis1.getParent();
            if (parent1 == null) {
                EList axis = this.getAxisManager(axis1, axis2).getRepresentedContentProvider().getAxis();
                index1 = axis.indexOf(axis1);
                index2 = axis.indexOf(axis2);
            } else {
                TreeFillingConfiguration conf = (TreeFillingConfiguration)parent1.getElement();
                ITreeItemAxis grandFather1 = parent1.getParent();
                Object context = null;
                context = grandFather1 == null ? this.manager.getTable().getContext() : grandFather1.getElement();
                Collection<?> values = CellManagerFactory.INSTANCE.getCrossValueAsCollection(conf.getAxisUsedAsAxisProvider(), context, this.manager);
                if (values instanceof List) {
                    index1 = ((List)values).indexOf(axis1.getElement());
                    index2 = ((List)values).indexOf(axis2.getElement());
                    if (index1 != -1 || index2 != -1) {
                        if (index1 == -1) {
                            index1 = index2 + 1;
                        } else if (index2 == -1) {
                            index2 = index1 + 1;
                        }
                    }
                } else {
                    index2 = 0;
                    index1 = 0;
                }
            }
        }
        int res = index1 - index2;
        return Integer.signum(res);
    }

    private IAxisManager getAxisManager(ITreeItemAxis axis1, ITreeItemAxis axis2) {
        if (this.axisManager != null) {
            return this.axisManager;
        }
        IAxisManager axisManager = this.manager.getRowAxisManager();
        Assert.isTrue((boolean)(axisManager instanceof ICompositeAxisManager));
        IAxisManager subAxisManager1 = ((ICompositeAxisManager)axisManager).getSubAxisManagerFor((IAxis)axis1);
        IAxisManager subAxisManager2 = ((ICompositeAxisManager)axisManager).getSubAxisManagerFor((IAxis)axis2);
        if (subAxisManager1 != null && subAxisManager1 != subAxisManager2) {
            throw new UnsupportedOperationException("this case is not yet supported");
        }
        return subAxisManager1;
    }
}

