/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.revision.delta;

import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDeltaVisitor;
import org.eclipse.emf.cdo.common.revision.delta.CDOSetFeatureDelta;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOSingleValueFeatureDeltaImpl;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDOFeatureDelta;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;

public class CDOSetFeatureDeltaImpl
extends CDOSingleValueFeatureDeltaImpl
implements CDOSetFeatureDelta,
InternalCDOFeatureDelta.ListTargetAdding {
    private static final ThreadLocal<Boolean> TRANSFER_OLD_VALUE = new ThreadLocal();
    private Object oldValue = UNKNOWN_VALUE;

    public CDOSetFeatureDeltaImpl(EStructuralFeature feature, int index, Object value) {
        super(feature, index, value);
    }

    public CDOSetFeatureDeltaImpl(EStructuralFeature feature, int index, Object value, Object oldValue) {
        super(feature, index, value);
        this.oldValue = oldValue;
    }

    public CDOSetFeatureDeltaImpl(CDODataInput in, EClass eClass) throws IOException {
        super(in, eClass);
        if (TRANSFER_OLD_VALUE.get() == Boolean.TRUE) {
            this.oldValue = this.readValue(in, eClass);
        }
    }

    @Override
    public void write(CDODataOutput out, EClass eClass) throws IOException {
        super.write(out, eClass);
        if (TRANSFER_OLD_VALUE.get() == Boolean.TRUE) {
            this.writeValue(out, eClass, this.oldValue);
        }
    }

    @Override
    public CDOFeatureDelta.Type getType() {
        return CDOFeatureDelta.Type.SET;
    }

    @Override
    public CDOFeatureDelta copy() {
        return new CDOSetFeatureDeltaImpl(this.getFeature(), this.getIndex(), this.getValue(), this.getOldValue());
    }

    @Override
    public Object applyTo(CDORevision revision) {
        EStructuralFeature feature = this.getFeature();
        int index = this.getIndex();
        Object value = this.getValue();
        InternalCDORevision internalRevision = (InternalCDORevision)revision;
        return internalRevision.set(feature, index, value);
    }

    @Override
    public void accept(CDOFeatureDeltaVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Object getOldValue() {
        return this.oldValue;
    }

    public void setOldValue(Object oldValue) {
        this.oldValue = oldValue;
    }

    @Override
    protected String toStringAdditional() {
        return String.valueOf(super.toStringAdditional()) + MessageFormat.format(", oldValue={0}", this.oldValue);
    }

    public static void transferOldValue(boolean on) {
        if (on) {
            TRANSFER_OLD_VALUE.set(Boolean.TRUE);
        } else {
            TRANSFER_OLD_VALUE.remove();
        }
    }
}

