/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ua.core.ctxhelp.text;

import java.util.Collection;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.internal.ua.core.ctxhelp.text.CtxHelpModel;
import org.xml.sax.SAXParseException;

public class CtxHelpMarkerManager {
    public static void refreshMarkers(CtxHelpModel model) {
        CtxHelpMarkerManager.deleteMarkers(model);
        CtxHelpMarkerManager.createMarkers(model);
    }

    public static void deleteMarkers(CtxHelpModel model) {
        try {
            IMarker[] problems = model.getUnderlyingResource().findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
            if (problems != null) {
                IMarker[] iMarkerArray = problems;
                int n = problems.length;
                int n2 = 0;
                while (n2 < n) {
                    IMarker problem = iMarkerArray[n2];
                    problem.delete();
                    ++n2;
                }
            }
        }
        catch (CoreException coreException) {}
    }

    public static void createMarkers(CtxHelpModel model) {
        Collection<Exception> errors = model.getErrors();
        if (errors == null || errors.isEmpty()) {
            return;
        }
        for (Throwable throwable : errors) {
            if (!(throwable instanceof SAXParseException)) continue;
            int line = ((SAXParseException)throwable).getLineNumber();
            try {
                Map<String, String> attributes = Map.of("lineNumber", line, "severity", 2, "message", throwable.getLocalizedMessage());
                model.getUnderlyingResource().createMarker("org.eclipse.core.resources.problemmarker", attributes);
            }
            catch (CoreException coreException) {}
        }
    }
}

