/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.debug.core.IJavaType;
import org.eclipse.jdt.debug.core.IJavaValue;
import org.eclipse.jdt.debug.core.IJavaVariable;
import org.eclipse.jdt.debug.ui.IJavaDebugUIConstants;
import org.eclipse.jdt.internal.debug.core.model.JDIInterfaceType;
import org.eclipse.jdt.internal.debug.core.model.JDIObjectValue;
import org.eclipse.jdt.internal.debug.core.model.JDIVariable;
import org.eclipse.jdt.internal.debug.ui.actions.OpenVariableDeclaredTypeAction;
import org.eclipse.jdt.internal.debug.ui.actions.OpenVariableTypeAction;
import org.eclipse.jface.action.IAction;

public class OpenVariableConcreteTypeAction
extends OpenVariableTypeAction {
    @Override
    protected IJavaType getTypeToOpen(IDebugElement element) throws CoreException {
        if (element instanceof IJavaVariable) {
            IJavaVariable variable = (IJavaVariable)element;
            return ((IJavaValue)variable.getValue()).getJavaType();
        }
        return null;
    }

    @Override
    protected boolean openElement(IAction action, Object element) throws DebugException, CoreException {
        JDIObjectValue val;
        JDIVariable jdiVariable;
        if (element instanceof JDIVariable && this.isInterfaceType(jdiVariable = (JDIVariable)element) && (val = (JDIObjectValue)jdiVariable.getValue()).getJavaType().toString().contains("$$Lambda$")) {
            OpenVariableDeclaredTypeAction declaredAction = new OpenVariableDeclaredTypeAction();
            declaredAction.setActivePart(action, this.getPart());
            declaredAction.run(action);
            return true;
        }
        IType sourceElement = this.resolveSourceElement(element);
        if (sourceElement != null) {
            this.openInEditor(element, sourceElement);
            return false;
        }
        Status status = new Status(1, IJavaDebugUIConstants.PLUGIN_ID, 150, "Source not found", null);
        throw new CoreException((IStatus)status);
    }

    private boolean isInterfaceType(JDIVariable jdiVariable) {
        try {
            return jdiVariable.getJavaType() instanceof JDIInterfaceType;
        }
        catch (DebugException debugException) {
            return false;
        }
    }
}

