/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.ui.views;

import org.eclipse.emf.cdo.CDOElement;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.ui.widgets.TimeSlider;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.net4j.util.AdapterUtil;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;

public class CDOTimeMachineView
extends ViewPart
implements ISelectionListener {
    public static final String ID = "org.eclipse.emf.cdo.ui.CDOTimeMachineView";
    private TimeSlider timeSlider;

    public void createPartControl(Composite parent) {
        this.timeSlider = new TimeSlider(parent, 0);
        IWorkbenchPage page = this.getSite().getPage();
        this.selectionChanged(null, page.getSelection());
        page.addSelectionListener((ISelectionListener)this);
    }

    public void dispose() {
        this.getSite().getPage().removeSelectionListener((ISelectionListener)this);
        this.timeSlider.disconnect();
        super.dispose();
    }

    public void setFocus() {
        this.timeSlider.setFocus();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        CDOView view = this.getView(selection);
        if (view != null && view.properties().get((Object)"timeMachineDisabled") == Boolean.TRUE) {
            view = null;
        }
        this.timeSlider.connect(view, null);
    }

    private CDOView getView(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)selection;
            for (Object element : ssel) {
                if (element instanceof CDOElement) {
                    element = ((CDOElement)element).getDelegate();
                }
                if (element instanceof EObject) {
                    CDOView view;
                    EObject eObject = (EObject)element;
                    CDOObject cdoObject = CDOUtil.getCDOObject((EObject)eObject);
                    if (cdoObject == null || (view = cdoObject.cdoView()) == null || !view.isReadOnly()) continue;
                    return view;
                }
                CDOView view = (CDOView)AdapterUtil.adapt(element, CDOView.class);
                if (view == null || !view.isReadOnly()) continue;
                return view;
            }
        }
        return null;
    }
}

