/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.commit;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.core.internal.Utils;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIUtils;
import org.eclipse.egit.ui.internal.UIIcons;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.commit.DiffDocument;
import org.eclipse.egit.ui.internal.commit.DiffRegionFormatter;
import org.eclipse.egit.ui.internal.commit.DiffViewer;
import org.eclipse.egit.ui.internal.history.CommitFileDiffViewer;
import org.eclipse.egit.ui.internal.history.FileDiff;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.util.StringUtils;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SearchPattern;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;

public class DiffEditorOutlinePage
extends ContentOutlinePage {
    static final Comparator<String> CMP = (left, right) -> {
        String l = left.startsWith("/") ? left.substring(1) : left;
        String r = right.startsWith("/") ? right.substring(1) : right;
        return l.replace('/', '\u0001').compareToIgnoreCase(r.replace('/', '\u0001'));
    };
    private IDocument input;
    private CopyOnWriteArrayList<IOpenListener> openListeners = new CopyOnWriteArrayList();
    private ISelection selection;
    private ActionHandler collapseHandler;
    private IAction collapseAction;
    private IAction togglePresentationAction;

    public void createControl(Composite parent) {
        super.createControl(parent);
        TreeViewer viewer = this.getTreeViewer();
        viewer.setAutoExpandLevel(-1);
        viewer.setUseHashlookup(true);
        viewer.setContentProvider((IContentProvider)new DiffContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new DiffLabelProvider());
        viewer.setComparator(new ViewerComparator(CMP){

            public int category(Object element) {
                if (element instanceof DiffContentProvider.Folder) {
                    return 0;
                }
                return 1;
            }
        });
        viewer.addDoubleClickListener(event -> this.openFolder(event.getSelection()));
        viewer.addOpenListener(this::fireOpenEvent);
        if (this.input != null) {
            viewer.setInput((Object)this.input);
            this.updateToolbarActions();
        }
        this.createContextMenu(viewer);
        if (this.selection != null) {
            viewer.setSelection(this.selection);
        }
    }

    public void setInput(IDocument input) {
        this.input = input;
        TreeViewer viewer = this.getTreeViewerChecked();
        if (viewer != null) {
            viewer.setInput((Object)input);
            this.updateToolbarActions();
        }
    }

    public void setSelection(ISelection selection) {
        this.selection = selection;
        TreeViewer viewer = this.getTreeViewerChecked();
        if (viewer != null) {
            super.setSelection(selection);
        }
    }

    private TreeViewer getTreeViewerChecked() {
        TreeViewer viewer = this.getTreeViewer();
        if (viewer == null || viewer.getControl() == null || viewer.getControl().isDisposed()) {
            return null;
        }
        return viewer;
    }

    public void addOpenListener(IOpenListener listener) {
        this.openListeners.addIfAbsent(listener);
    }

    public void removeOpenListener(IOpenListener listener) {
        this.openListeners.remove(listener);
    }

    private void openFolder(ISelection currentSelection) {
        TreeViewer viewer;
        Object currentNode;
        if (currentSelection instanceof IStructuredSelection && (currentNode = ((IStructuredSelection)currentSelection).getFirstElement()) instanceof DiffContentProvider.Folder && (viewer = this.getTreeViewerChecked()) != null) {
            viewer.setExpandedState(currentNode, !viewer.getExpandedState(currentNode));
        }
    }

    private void fireOpenEvent(final OpenEvent event) {
        for (final IOpenListener listener : this.openListeners) {
            SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    listener.open(event);
                }
            });
        }
    }

    private void createContextMenu(TreeViewer viewer) {
        MenuManager contextMenu = new MenuManager();
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener(menuManager -> {
            boolean hasFiles;
            this.setFocus();
            final Collection<DiffRegionFormatter.FileDiffRegion> selected = this.getSelectedFileDiffs();
            if (selected.isEmpty()) {
                return;
            }
            final List haveNew = selected.stream().filter(diff -> !diff.getDiff().getChange().equals((Object)DiffEntry.ChangeType.DELETE)).collect(Collectors.toList());
            final List haveOld = selected.stream().filter(diff -> !diff.getDiff().getChange().equals((Object)DiffEntry.ChangeType.ADD)).collect(Collectors.toList());
            final List existing = haveNew.stream().filter(diff -> new Path(diff.getDiff().getRepository().getWorkTree().getAbsolutePath()).append(diff.getDiff().getNewPath()).toFile().exists()).collect(Collectors.toList());
            if (!existing.isEmpty()) {
                menuManager.add((IAction)new Action(UIText.CommitFileDiffViewer_OpenWorkingTreeVersionInEditorMenuLabel){

                    public void run() {
                        for (DiffRegionFormatter.FileDiffRegion fileDiff : existing) {
                            File file = new Path(fileDiff.getDiff().getRepository().getWorkTree().getAbsolutePath()).append(fileDiff.getDiff().getNewPath()).toFile();
                            DiffViewer.openFileInEditor(file, -1);
                        }
                    }
                });
            }
            if (!haveNew.isEmpty()) {
                RevCommit commit = ((DiffRegionFormatter.FileDiffRegion)((Object)((Object)haveNew.get(0)))).getDiff().getCommit();
                String title = MessageFormat.format(UIText.CommitFileDiffViewer_OpenInEditorMenuWithCommitLabel, Utils.getShortObjectId((ObjectId)commit));
                String tooltip = MessageFormat.format(UIText.CommitFileDiffViewer_OpenInEditorMenuTooltip, UIUtils.menuText(commit.getShortMessage(), 80));
                Action action = new Action(title){

                    public void run() {
                        for (DiffRegionFormatter.FileDiffRegion fileDiff : haveNew) {
                            DiffViewer.openInEditor(fileDiff.getDiff(), DiffEntry.Side.NEW, -1);
                        }
                    }
                };
                if (tooltip != null) {
                    action.setToolTipText(tooltip);
                }
                menuManager.add((IAction)action);
            }
            if (!haveOld.isEmpty()) {
                String msg;
                FileDiff diff2 = ((DiffRegionFormatter.FileDiffRegion)((Object)((Object)haveOld.get(0)))).getDiff();
                RevCommit commit = diff2.getCommit();
                RevCommit base = diff2.getBase();
                if (base == null || base.equals((AnyObjectId)commit.getParent(0))) {
                    msg = UIText.CommitFileDiffViewer_OpenPreviousInEditorMenuWithCommitLabel;
                    if (base == null) {
                        base = commit.getParent(0);
                    }
                } else {
                    msg = UIText.CommitFileDiffViewer_OpenBaseInEditorMenuWithCommitLabel;
                }
                String title = MessageFormat.format(msg, Utils.getShortObjectId((ObjectId)base));
                String tooltip = MessageFormat.format(UIText.CommitFileDiffViewer_OpenInEditorMenuTooltip, UIUtils.menuText(base.getShortMessage(), 80));
                Action action = new Action(title){

                    public void run() {
                        for (DiffRegionFormatter.FileDiffRegion fileDiff : haveOld) {
                            DiffViewer.openInEditor(fileDiff.getDiff(), DiffEntry.Side.OLD, -1);
                        }
                    }
                };
                if (tooltip != null) {
                    action.setToolTipText(tooltip);
                }
                menuManager.add((IAction)action);
            }
            if (!haveNew.isEmpty() && (hasFiles = haveNew.stream().anyMatch(d -> !d.getDiff().isSubmodule()))) {
                menuManager.add((IContributionItem)new Separator());
                CommitFileDiffViewer.CheckoutAction action = new CommitFileDiffViewer.CheckoutAction(this::getStructuredSelection);
                menuManager.add((IAction)action);
                action.setEnabled(((DiffRegionFormatter.FileDiffRegion)((Object)((Object)haveNew.iterator().next()))).getDiff().getRepository().getRepositoryState().equals((Object)RepositoryState.SAFE));
            }
            if (selected.size() == 1 && !haveNew.isEmpty() && !haveOld.isEmpty()) {
                FileDiff diff3 = ((DiffRegionFormatter.FileDiffRegion)((Object)((Object)haveNew.get(0)))).getDiff();
                RevCommit base = diff3.getBase();
                String title = base == null || base.equals((AnyObjectId)diff3.getCommit().getParent(0)) ? UIText.CommitFileDiffViewer_CompareMenuLabel : UIText.CommitFileDiffViewer_CompareSideBySideMenuLabel;
                menuManager.add((IContributionItem)new Separator());
                menuManager.add((IAction)new Action(title){

                    public void run() {
                        DiffRegionFormatter.FileDiffRegion fileDiff = (DiffRegionFormatter.FileDiffRegion)((Object)selected.iterator().next());
                        DiffViewer.showTwoWayFileDiff(fileDiff.getDiff());
                    }
                });
            }
        });
        Menu menu = contextMenu.createContextMenu((Control)viewer.getTree());
        viewer.getTree().setMenu(menu);
    }

    private IStructuredSelection getStructuredSelection() {
        ISelection currentSelection = this.getSelection();
        if (currentSelection instanceof IStructuredSelection) {
            return (IStructuredSelection)currentSelection;
        }
        return StructuredSelection.EMPTY;
    }

    private Collection<DiffRegionFormatter.FileDiffRegion> getSelectedFileDiffs() {
        IStructuredSelection currentSelection = this.getStructuredSelection();
        ArrayList<DiffRegionFormatter.FileDiffRegion> result = new ArrayList<DiffRegionFormatter.FileDiffRegion>();
        if (!currentSelection.isEmpty()) {
            for (Object selected : ((StructuredSelection)currentSelection).toList()) {
                if (!(selected instanceof DiffRegionFormatter.FileDiffRegion) || ((DiffRegionFormatter.FileDiffRegion)((Object)selected)).getDiff().isSubmodule()) continue;
                result.add((DiffRegionFormatter.FileDiffRegion)((Object)selected));
            }
        }
        return result;
    }

    public void setActionBars(IActionBars actionBars) {
        super.setActionBars(actionBars);
        this.addToolbarActions(actionBars.getToolBarManager());
    }

    private void addToolbarActions(IToolBarManager toolbarManager) {
        this.collapseAction = new Action(UIText.UIUtils_CollapseAll, PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ELCL_COLLAPSEALL")){

            public void run() {
                UIUtils.collapseAll((AbstractTreeViewer)DiffEditorOutlinePage.this.getTreeViewer());
            }
        };
        this.collapseAction.setActionDefinitionId("org.eclipse.ui.navigate.collapseAll");
        this.collapseHandler = new ActionHandler(this.collapseAction);
        IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
        handlerService.activateHandler(this.collapseAction.getActionDefinitionId(), (IHandler)this.collapseHandler);
        final IPreferenceStore preferences = Activator.getDefault().getPreferenceStore();
        this.togglePresentationAction = new Action(UIText.DiffEditor_OutlineTreeToggle, 2){

            public void run() {
                boolean compact = this.isChecked();
                preferences.setValue("DiffEditorOutline.compactTree", compact);
                ((DiffContentProvider)DiffEditorOutlinePage.this.getTreeViewer().getContentProvider()).setCompactTree(compact);
                DiffEditorOutlinePage.this.getTreeViewer().setInput(DiffEditorOutlinePage.this.getTreeViewer().getInput());
            }
        };
        this.togglePresentationAction.setImageDescriptor(UIIcons.COMPACT);
        this.togglePresentationAction.setToolTipText(UIText.DiffEditor_OutlineShowCompactTreeTooltip);
        boolean compact = preferences.getBoolean("DiffEditorOutline.compactTree");
        this.togglePresentationAction.setChecked(compact);
        this.updateToolbarActions();
        toolbarManager.add(this.collapseAction);
        toolbarManager.add(this.togglePresentationAction);
        ((DiffContentProvider)this.getTreeViewer().getContentProvider()).setCompactTree(compact);
        this.getTreeViewer().setInput(this.getTreeViewer().getInput());
    }

    private void updateToolbarActions() {
        TreeViewer viewer = this.getTreeViewerChecked();
        if (viewer == null) {
            return;
        }
        boolean hasElements = ((DiffContentProvider)viewer.getContentProvider()).hasElements();
        if (this.collapseAction != null) {
            this.collapseAction.setEnabled(hasElements);
        }
        if (this.togglePresentationAction != null) {
            this.togglePresentationAction.setEnabled(hasElements);
        }
    }

    public void dispose() {
        if (this.collapseHandler != null) {
            this.collapseHandler.dispose();
        }
        super.dispose();
    }

    static void openQuickOutline(IDocument document, ISelectionProvider selectionProvider) {
        new QuickOutlinePopup(document, selectionProvider).open();
    }

    private static class DiffContentProvider
    implements ITreeContentProvider {
        private static final Object[] NOTHING = new Object[0];
        private static final String SLASH = "/";
        private boolean compactTree = false;
        private HashMap<String, Folder> rootFolders = new LinkedHashMap<String, Folder>();
        private Map<Object, Folder> parents = new HashMap<Object, Folder>();

        private DiffContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.rootFolders.clear();
            this.parents.clear();
            if (newInput instanceof DiffDocument) {
                this.computeFolders(((DiffDocument)((Object)newInput)).getFileRegions());
            }
        }

        public void setCompactTree(boolean compactTree) {
            this.compactTree = compactTree;
        }

        public void dispose() {
            this.rootFolders.clear();
            this.parents.clear();
        }

        public boolean hasElements() {
            return !this.rootFolders.isEmpty();
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof DiffDocument) {
                return this.rootFolders.values().toArray();
            }
            return NOTHING;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof Folder) {
                ArrayList<Object> children = new ArrayList<Object>();
                Folder parentFolder = (Folder)parentElement;
                children.addAll(parentFolder.folders);
                children.addAll(parentFolder.files);
                return children.toArray();
            }
            return NOTHING;
        }

        public Object getParent(Object element) {
            return this.parents.get(element);
        }

        public boolean hasChildren(Object element) {
            return element instanceof Folder;
        }

        private void computeFolders(DiffRegionFormatter.FileDiffRegion[] ranges) {
            if (this.compactTree) {
                DiffRegionFormatter.FileDiffRegion[] fileDiffRegionArray = ranges;
                int n = ranges.length;
                int n2 = 0;
                while (n2 < n) {
                    DiffRegionFormatter.FileDiffRegion range = fileDiffRegionArray[n2];
                    String path = range.getDiff().getPath();
                    Folder folder = this.computeRootFolder(SLASH);
                    String[] segments = path.split(SLASH);
                    int i = 0;
                    while (i < segments.length - 1) {
                        String segment = segments[i];
                        Folder newFolder = null;
                        for (Folder childFolder : folder.folders) {
                            if (!childFolder.name.equals(segment)) continue;
                            newFolder = childFolder;
                            break;
                        }
                        if (newFolder == null) {
                            newFolder = new Folder(segment);
                            folder.folders.add(newFolder);
                        }
                        this.parents.put(newFolder, folder);
                        folder = newFolder;
                        ++i;
                    }
                    folder.files.add(range);
                    this.parents.put((Object)range, folder);
                    ++n2;
                }
                this.compactify();
            } else {
                DiffRegionFormatter.FileDiffRegion[] fileDiffRegionArray = ranges;
                int n = ranges.length;
                int n3 = 0;
                while (n3 < n) {
                    DiffRegionFormatter.FileDiffRegion range = fileDiffRegionArray[n3];
                    String path = range.getDiff().getPath();
                    int i = path.lastIndexOf(47);
                    path = i > 0 ? path.substring(0, i) : SLASH;
                    Folder folder = this.computeRootFolder(path);
                    folder.files.add(range);
                    this.parents.put((Object)range, folder);
                    ++n3;
                }
            }
        }

        private void compactify() {
            Folder root = this.rootFolders.get(SLASH);
            if (root == null) {
                return;
            }
            this.compactify(root);
            if (root.files.isEmpty()) {
                this.rootFolders.clear();
                root.folders.forEach(f -> {
                    this.parents.remove(f);
                    this.rootFolders.put(f.name, (Folder)f);
                });
            }
        }

        private void compactify(Folder folder) {
            if (folder.files.isEmpty() && folder.folders.size() == 1) {
                Folder parent = this.parents.get(folder);
                Folder child = folder.folders.get(0);
                if (parent != null) {
                    child.name = String.valueOf(folder.name) + SLASH + child.name;
                    parent.folders.remove(folder);
                    parent.folders.add(child);
                    this.parents.remove(folder);
                    this.parents.put(child, parent);
                }
            }
            new ArrayList<Folder>(folder.folders).forEach(f -> this.compactify((Folder)f));
        }

        private Folder computeRootFolder(String path) {
            return this.rootFolders.computeIfAbsent(path, Folder::new);
        }

        public static class Folder {
            public String name;
            public List<Folder> folders;
            public List<DiffRegionFormatter.FileDiffRegion> files;

            public Folder(String name) {
                this.name = name;
                this.folders = new ArrayList<Folder>();
                this.files = new ArrayList<DiffRegionFormatter.FileDiffRegion>();
            }
        }
    }

    private static class DiffLabelProvider
    extends LabelProvider {
        private final Image FOLDER = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
        private final ResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources());

        public Image getImage(Object element) {
            if (element instanceof DiffContentProvider.Folder) {
                return this.FOLDER;
            }
            if (element instanceof DiffRegionFormatter.FileDiffRegion) {
                FileDiff diff = ((DiffRegionFormatter.FileDiffRegion)((Object)element)).getDiff();
                ImageDescriptor desc = diff.getBaseImageDescriptor();
                if (desc == null) {
                    return null;
                }
                Image image = UIIcons.getImage(this.resourceManager, desc);
                desc = diff.getImageDcoration();
                if (desc != null) {
                    image = UIIcons.getImage(this.resourceManager, (ImageDescriptor)new DecorationOverlayIcon(image, desc, 3));
                }
                return image;
            }
            return super.getImage(element);
        }

        public String getText(Object element) {
            if (element instanceof DiffContentProvider.Folder) {
                return ((DiffContentProvider.Folder)element).name;
            }
            if (element instanceof DiffRegionFormatter.FileDiffRegion) {
                FileDiff diff = ((DiffRegionFormatter.FileDiffRegion)((Object)element)).getDiff();
                String path = diff.getPath();
                int i = path.lastIndexOf(47);
                return path.substring(i + 1);
            }
            return super.getText(element);
        }

        public void dispose() {
            this.resourceManager.dispose();
            super.dispose();
        }
    }

    private static class QuickOutlinePopup
    extends PopupDialog {
        private DiffEditorOutlinePage delegate = new DiffEditorOutlinePage();
        private ISelectionProvider selectionProvider;
        private Text filterText;

        public QuickOutlinePopup(IDocument document, ISelectionProvider selectionProvider) {
            this(null, document, selectionProvider);
        }

        public QuickOutlinePopup(Shell parent, IDocument document, ISelectionProvider selectionProvider) {
            super(parent, 16, true, false, true, true, true, UIText.DiffEditor_QuickOutlineAction, UIText.DiffEditor_QuickOutlineFilterDescription);
            this.delegate.setInput(document);
            this.selectionProvider = selectionProvider;
        }

        protected Control createTitleControl(Composite parent) {
            this.filterText = this.createFilterText(parent);
            return this.filterText;
        }

        protected Control getFocusControl() {
            return this.filterText;
        }

        private Text createFilterText(Composite parent) {
            this.filterText = new Text(parent, 0);
            Dialog.applyDialogFont((Control)this.filterText);
            GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.filterText);
            this.filterText.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    if (e.keyCode == 13 || e.character == '\r' || e.character == '\n') {
                        this.gotoSelectedElement();
                        this.close();
                    } else if (e.keyCode == 0x1000002) {
                        delegate.getTreeViewer().getTree().setFocus();
                        this.selectFirst();
                    } else if (e.character == '\u001b') {
                        this.close();
                    }
                }
            });
            this.filterText.setMessage(UIText.DiffEditor_QuickOutlineFilterHint);
            this.filterText.addModifyListener(e -> {
                TreeViewer viewer = this.delegate.getTreeViewer();
                try {
                    viewer.getControl().setRedraw(false);
                    String text = this.filterText.getText();
                    if (StringUtils.isEmptyOrNull((String)text)) {
                        viewer.setFilters(new ViewerFilter[0]);
                    } else {
                        final SearchPattern pattern = new SearchPattern();
                        pattern.setPattern(text);
                        viewer.setFilters(new ViewerFilter[]{new ViewerFilter(){

                            public boolean select(Viewer v, Object parentElement, Object element) {
                                return this.isMatch(pattern, element);
                            }
                        }});
                    }
                    viewer.expandAll();
                    this.selectFirst();
                }
                finally {
                    viewer.getControl().setRedraw(true);
                }
            });
            return this.filterText;
        }

        private void selectFirst() {
            TreeItem folder;
            TreeViewer viewer = this.delegate.getTreeViewer();
            Tree tree = viewer.getTree();
            if (tree.getItemCount() > 0 && (folder = tree.getItem(0)).getItemCount() > 0) {
                TreeItem file = folder.getItem(0);
                viewer.setSelection((ISelection)new StructuredSelection(file.getData()));
                this.gotoSelectedElement();
            }
        }

        private boolean isMatch(SearchPattern pattern, Object treeElement) {
            if (treeElement instanceof DiffRegionFormatter.FileDiffRegion) {
                String path;
                String fileName = path = ((DiffRegionFormatter.FileDiffRegion)((Object)treeElement)).getDiff().getPath();
                int lastSegmentIndex = path.lastIndexOf(47);
                if (lastSegmentIndex >= 0 && pattern.matches(fileName = path.substring(lastSegmentIndex + 1))) {
                    return true;
                }
                return pattern.matches(path);
            }
            if (treeElement instanceof DiffContentProvider.Folder) {
                DiffContentProvider.Folder folder = (DiffContentProvider.Folder)treeElement;
                return folder.files.stream().anyMatch(r -> this.isMatch(pattern, r)) || folder.folders.stream().anyMatch(f -> this.isMatch(pattern, f));
            }
            return false;
        }

        protected Control createDialogArea(Composite parent) {
            this.delegate.createControl(parent);
            Tree tree = this.delegate.getTreeViewer().getTree();
            tree.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    if (e.character == '\u001b') {
                        this.close();
                    }
                }
            });
            tree.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    selectionProvider.setSelection(delegate.getTreeViewer().getSelection());
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                    ITreeSelection selection = delegate.getTreeViewer().getStructuredSelection();
                    if (selection.getFirstElement() instanceof DiffRegionFormatter.FileDiffRegion) {
                        this.close();
                    }
                }
            });
            tree.setMenu(null);
            return this.delegate.getTreeViewer().getControl();
        }

        private void gotoSelectedElement() {
            ITreeSelection sel = this.delegate.getTreeViewer().getStructuredSelection();
            if (!sel.isEmpty()) {
                this.selectionProvider.setSelection((ISelection)sel);
            }
        }

        public boolean close() {
            this.delegate.dispose();
            return super.close();
        }

        protected IDialogSettings getDialogSettings() {
            String sectionName = "diffEditor.quickoutline";
            IDialogSettings settings = Activator.getDefault().getDialogSettings().getSection(sectionName);
            if (settings == null) {
                settings = Activator.getDefault().getDialogSettings().addNewSection(sectionName);
            }
            return settings;
        }

        protected Point getDefaultLocation(Point initialSize) {
            IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
            Control widget = (Control)editor.getAdapter(Control.class);
            Point size = widget.getSize();
            Point popupLocation = new Point(size.x / 2 - initialSize.x / 2, size.y / 2 - initialSize.y / 2);
            return widget.toDisplay(popupLocation);
        }
    }
}

