/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.core;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.methods.GetMethod;

public class GzipGetMethod
extends GetMethod {
    private final boolean gzipWanted;

    public GzipGetMethod(String requestPath, boolean gzipWanted) {
        super(requestPath);
        this.gzipWanted = gzipWanted;
    }

    public int execute(HttpState state, HttpConnection conn) throws HttpException, IOException {
        if (this.gzipWanted) {
            this.setRequestHeader("Accept-encoding", "gzip");
        }
        int result = super.execute(state, conn);
        return result;
    }

    @Deprecated
    public void getResponseBodyNoop() throws IOException {
        try {
            InputStream instream = this.getResponseBodyAsStream();
            if (instream != null) {
                byte[] buffer = new byte[4096];
                while (instream.read(buffer) > 0) {
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

