/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.decoratormodel.internal.ui.wizards;

import com.google.common.collect.Maps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.uml.decoratormodel.helper.DecoratorModelUtils;
import org.eclipse.papyrus.uml.decoratormodel.internal.resource.DecoratorModelIndex;
import org.eclipse.papyrus.uml.decoratormodel.internal.ui.Activator;
import org.eclipse.papyrus.uml.decoratormodel.internal.ui.messages.Messages;
import org.eclipse.papyrus.uml.decoratormodel.internal.ui.preferences.ProfileExternalizationUIPreferences;
import org.eclipse.papyrus.uml.decoratormodel.internal.ui.wizards.AbstractProfileApplicationSelectionPage;
import org.eclipse.papyrus.uml.decoratormodel.internal.ui.wizards.DecoratorModelSelectionPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.uml2.uml.Package;

public class ConflictingDecoratorModelsPage
extends DecoratorModelSelectionPage {
    private IFile[] resourcesSelectedForLoad;
    private IFile[] conflicts;
    private Button selectConflicts;
    private Map<URI, Map<URI, URI>> loadedExternalApplications;

    public ConflictingDecoratorModelsPage(EventBus bus) {
        this(bus, null);
    }

    public ConflictingDecoratorModelsPage(EventBus bus, ImageDescriptor titleImage) {
        super("unload", Messages.ConflictingDecoratorModelsPage_0, bus, titleImage);
        bus.register((Object)this);
        this.setMessage(Messages.ConflictingDecoratorModelsPage_1);
    }

    @Override
    public void setInput(Package package_, Set<URI> input) {
        super.setInput(package_, input);
        this.loadedExternalApplications = Maps.newHashMap();
        ResourceSet rset = EMFHelper.getResourceSet((EObject)package_);
        for (URI next : input) {
            Resource resource = rset.getResource(next, true);
            for (Map.Entry external : DecoratorModelUtils.getDecoratorProfileApplications((Resource)resource).entrySet()) {
                URI packageURI = EcoreUtil.getURI((EObject)((EObject)external.getKey()));
                HashMap profiles = this.loadedExternalApplications.get(packageURI);
                if (profiles == null) {
                    profiles = Maps.newHashMap();
                    this.loadedExternalApplications.put(packageURI, profiles);
                }
                profiles.put(EcoreUtil.getURI((EObject)((EObject)external.getValue())), next);
            }
        }
        this.conflicts = this.computeConflicts(this.resourcesSelectedForLoad);
        this.validatePage();
    }

    @Override
    protected void createSpecialSelectionButtons(Composite parent) {
        this.selectConflicts = AbstractProfileApplicationSelectionPage.button(parent, Messages.ConflictingDecoratorModelsPage_2);
        this.selectConflicts.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IFile[] iFileArray = ConflictingDecoratorModelsPage.this.conflicts;
                int n = ConflictingDecoratorModelsPage.this.conflicts.length;
                int n2 = 0;
                while (n2 < n) {
                    IFile next = iFileArray[n2];
                    ConflictingDecoratorModelsPage.this.table.setChecked((Object)next, true);
                    ++n2;
                }
                ConflictingDecoratorModelsPage.this.validatePage();
            }
        });
        if (this.conflicts != null) {
            this.selectConflicts.setEnabled(this.conflicts.length > 0);
        }
    }

    @Override
    protected void storeDontShowThisPreference(boolean dontShowThisAgain) {
        ProfileExternalizationUIPreferences.setPromptToUnloadConflicts(!dontShowThisAgain);
    }

    public Set<URI> getResourcesToUnload() {
        return ConflictingDecoratorModelsPage.filesToURIs(this.getCheckedFiles());
    }

    @Subscribe
    public void resourcesSelectedForLoad(IFile[] resources) {
        this.resourcesSelectedForLoad = resources;
        this.conflicts = this.computeConflicts(resources);
        this.validatePage();
    }

    static Set<URI> filesToURIs(IFile[] files) {
        HashSet result = Sets.newHashSet();
        IFile[] iFileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            IFile next = iFileArray[n2];
            result.add(URI.createPlatformResourceURI((String)next.getFullPath().toString(), (boolean)true));
            ++n2;
        }
        return result;
    }

    protected IFile[] computeConflicts(IFile[] resources) {
        if (this.loadedExternalApplications == null || resources == null) {
            return new IFile[0];
        }
        HashSet result = Sets.newHashSet();
        Set<URI> uris = ConflictingDecoratorModelsPage.filesToURIs(resources);
        for (URI next : uris) {
            try {
                SetMultimap profileApplications = DecoratorModelIndex.getInstance().getAppliedProfilesByPackage(next);
                for (URI packageURI : profileApplications.keySet()) {
                    Map<URI, URI> existingAppliedProfiles = this.loadedExternalApplications.get(packageURI);
                    if (existingAppliedProfiles == null) continue;
                    Set newProfiles = profileApplications.get((Object)packageURI);
                    for (Map.Entry<URI, URI> profileToResource : existingAppliedProfiles.entrySet()) {
                        if (!newProfiles.contains(profileToResource.getKey())) continue;
                        result.add(profileToResource.getValue());
                    }
                }
            }
            catch (CoreException e) {
                Activator.getDefault().getLog().log(e.getStatus());
                StatusManager.getManager().handle(e.getStatus(), 2);
            }
        }
        if (!result.isEmpty() && this.showDontShowThis() && !ProfileExternalizationUIPreferences.getPromptToUnloadConflicts() && this.table == null) {
            this.select(result);
        }
        IFile[] conflicts = ConflictingDecoratorModelsPage.urisToFilesArray(result);
        if (this.selectConflicts != null) {
            this.selectConflicts.setEnabled(conflicts.length > 0);
        }
        return conflicts;
    }

    boolean anyConflictNotSelected() {
        boolean result = false;
        HashSet checked = Sets.newHashSet((Object[])this.getCheckedFiles());
        if (this.conflicts != null) {
            IFile[] iFileArray = this.conflicts;
            int n = this.conflicts.length;
            int n2 = 0;
            while (n2 < n) {
                IFile next = iFileArray[n2];
                if (!checked.contains(next)) {
                    result = true;
                    break;
                }
                ++n2;
            }
        }
        return result;
    }

    @Override
    void validatePage() {
        this.setErrorMessage(null);
        if (this.anyConflictNotSelected()) {
            this.setErrorMessage(Messages.ConflictingDecoratorModelsPage_3);
            this.setPageComplete(false);
        } else {
            this.setPageComplete(true);
        }
    }
}

