/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.paletteconfiguration.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.papyrus.infra.types.ElementTypeConfiguration;
import org.eclipse.papyrus.infra.types.ElementTypeSetConfiguration;
import org.eclipse.papyrus.infra.types.core.registries.ElementTypeSetConfigurationRegistry;
import org.eclipse.papyrus.infra.widgets.providers.IHierarchicContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;

public class ElementTypeSetConfigurationContentProvider
implements IStaticContentProvider,
IHierarchicContentProvider {
    private final ResourceSet resourceSet;

    public ElementTypeSetConfigurationContentProvider() {
        this(null);
    }

    public ElementTypeSetConfigurationContentProvider(ResourceSet resourceSet) {
        this.resourceSet = resourceSet;
    }

    public Object[] getElements(Object inputElement) {
        ArrayList<ElementTypeSetConfiguration> els = new ArrayList<ElementTypeSetConfiguration>();
        Collection values = ElementTypeSetConfigurationRegistry.getInstance().getElementTypeSetConfigurations().values();
        for (Map map : values) {
            Collection values2 = map.values();
            for (ElementTypeSetConfiguration elementTypeSetConfiguration : values2) {
                if (elementTypeSetConfiguration.getElementTypeConfigurations().isEmpty()) continue;
                els.add(elementTypeSetConfiguration);
            }
        }
        els.addAll(this.getLocalElementTypeSetConfigurations());
        return els.toArray();
    }

    private List<ElementTypeSetConfiguration> getLocalElementTypeSetConfigurations() {
        ArrayList<ElementTypeSetConfiguration> result = new ArrayList<ElementTypeSetConfiguration>();
        if (this.resourceSet != null) {
            this.resourceSet.getResources().stream().map(Resource::getContents).flatMap(Collection::stream).filter(ElementTypeSetConfiguration.class::isInstance).map(ElementTypeSetConfiguration.class::cast).forEach(result::add);
        }
        return result;
    }

    public Object[] getElements() {
        return this.getElements(null);
    }

    public Object[] getChildren(Object parentElement) {
        Object[] children = null;
        if (parentElement instanceof ElementTypeSetConfiguration) {
            children = ((ElementTypeSetConfiguration)parentElement).getElementTypeConfigurations().toArray();
        }
        return children;
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element) != null;
    }

    public boolean isValidValue(Object element) {
        return element instanceof ElementTypeConfiguration;
    }
}

