/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.manipulation.CleanUpContextCore;
import org.eclipse.jdt.core.manipulation.CleanUpRequirementsCore;
import org.eclipse.jdt.core.manipulation.ICleanUpFixCore;
import org.eclipse.jdt.internal.corext.fix.PatternMatchingForInstanceofFixCore;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.fix.AbstractCleanUpCore;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;

public class PatternMatchingForInstanceofCleanUpCore
extends AbstractCleanUpCore {
    public PatternMatchingForInstanceofCleanUpCore(Map<String, String> options) {
        super(options);
    }

    public PatternMatchingForInstanceofCleanUpCore() {
    }

    @Override
    public CleanUpRequirementsCore getRequirementsCore() {
        return new CleanUpRequirementsCore(this.requireAST(), false, false, null);
    }

    public boolean requireAST() {
        return this.isEnabled("cleanup.instanceof");
    }

    @Override
    public ICleanUpFixCore createFixCore(CleanUpContextCore context) throws CoreException {
        CompilationUnit compilationUnit = context.getAST();
        if (compilationUnit == null || !this.isEnabled("cleanup.instanceof") || !JavaModelUtil.is16OrHigher(compilationUnit.getJavaElement().getJavaProject())) {
            return null;
        }
        return PatternMatchingForInstanceofFixCore.createCleanUp(compilationUnit);
    }

    @Override
    public String[] getStepDescriptions() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.isEnabled("cleanup.instanceof")) {
            result.add(MultiFixMessages.PatternMatchingForInstanceofCleanup_description);
        }
        return result.toArray(new String[0]);
    }

    @Override
    public String getPreview() {
        if (this.isEnabled("cleanup.instanceof")) {
            return "if (object instanceof Integer i) {\n    return i.intValue();\n}\n\n";
        }
        return "if (object instanceof Integer) {\n    Integer i = (Integer) object;\n    return i.intValue();\n}\n";
    }
}

