/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.uml.diagram.common.services;

import java.util.List;
import java.util.Optional;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.papyrus.sirius.uml.diagram.common.Activator;
import org.eclipse.papyrus.sirius.uml.diagram.common.core.services.AbstractDiagramServices;
import org.eclipse.papyrus.sirius.uml.diagram.common.core.services.EditableChecker;
import org.eclipse.papyrus.sirius.uml.diagram.common.core.services.RepresentationQuerier;
import org.eclipse.papyrus.uml.domain.services.IEditableChecker;
import org.eclipse.papyrus.uml.domain.services.IViewQuerier;
import org.eclipse.papyrus.uml.domain.services.UMLHelper;
import org.eclipse.papyrus.uml.domain.services.create.CreationStatus;
import org.eclipse.papyrus.uml.domain.services.create.ElementBasedEdgeCreator;
import org.eclipse.papyrus.uml.domain.services.create.ElementConfigurer;
import org.eclipse.papyrus.uml.domain.services.create.ElementDomainBasedEdgeCreationChecker;
import org.eclipse.papyrus.uml.domain.services.create.IElementConfigurer;
import org.eclipse.papyrus.uml.domain.services.edges.ElementDomainBasedEdgeContainerProvider;
import org.eclipse.papyrus.uml.domain.services.edges.ElementDomainBasedEdgeInitializer;
import org.eclipse.papyrus.uml.domain.services.edges.ElementDomainBasedEdgeSourceProvider;
import org.eclipse.papyrus.uml.domain.services.edges.ElementDomainBasedEdgeTargetsProvider;
import org.eclipse.papyrus.uml.domain.services.edges.IDomainBasedEdgeContainerProvider;
import org.eclipse.papyrus.uml.domain.services.edges.IDomainBasedEdgeInitializer;
import org.eclipse.papyrus.uml.domain.services.modify.ElementFeatureModifier;
import org.eclipse.papyrus.uml.domain.services.modify.IFeatureModifier;
import org.eclipse.papyrus.uml.domain.services.status.CheckStatus;
import org.eclipse.papyrus.uml.domain.services.status.State;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.uml2.uml.UMLFactory;

public class DomainBasedEdgeServices
extends AbstractDiagramServices {
    public EObject getSource(EObject semanticElementEdge) {
        return new ElementDomainBasedEdgeSourceProvider().getSource(semanticElementEdge);
    }

    public List<? extends EObject> getTargets(EObject semanticElementEdge) {
        return new ElementDomainBasedEdgeTargetsProvider().getTargets(semanticElementEdge);
    }

    public boolean canCreateDomainBasedEdge(EObject source, EObject target, String type, String containementReferenceName, DSemanticDecorator sourceView, DSemanticDecorator targetView) {
        boolean canCreate = true;
        Optional<DDiagram> optionalDDiagram = Optional.ofNullable(sourceView).filter(DDiagramElement.class::isInstance).map(DDiagramElement.class::cast).map(DDiagramElement::getParentDiagram);
        RepresentationQuerier representationQuery = new RepresentationQuerier(optionalDDiagram.orElse(null));
        CheckStatus canCreateStatus = new ElementDomainBasedEdgeCreationChecker().canCreate(source, target, type, containementReferenceName, (IViewQuerier)representationQuery, (Object)sourceView, (Object)targetView);
        canCreate = canCreateStatus.isValid();
        if (canCreate) {
            ElementDomainBasedEdgeContainerProvider containerProvider = new ElementDomainBasedEdgeContainerProvider((IEditableChecker)new EditableChecker());
            EClass eClass = UMLHelper.toEClass((String)type);
            if (eClass != null) {
                EObject newInstance = UMLFactory.eINSTANCE.create(eClass);
                EObject container = containerProvider.getContainer(source, target, newInstance, (IViewQuerier)representationQuery, (Object)sourceView, (Object)targetView);
                canCreate = container != null;
            }
        }
        return canCreate;
    }

    public boolean canCreateDomainBasedEdgeFromSource(EObject source, String type, String containementReferenceName, DSemanticDecorator sourceView) {
        Optional<DDiagram> optionalDDiagram = Optional.ofNullable(sourceView).filter(DDiagramElement.class::isInstance).map(DDiagramElement.class::cast).map(DDiagramElement::getParentDiagram);
        RepresentationQuerier representationQuery = new RepresentationQuerier(optionalDDiagram.orElse(null));
        CheckStatus canCreateStatus = new ElementDomainBasedEdgeCreationChecker().canCreateFromSource(source, type, containementReferenceName, (IViewQuerier)representationQuery, (Object)sourceView);
        return canCreateStatus.isValid();
    }

    public EObject createDomainBasedEdge(EObject source, EObject target, String type, String containementReferenceName, DSemanticDecorator sourceView, DSemanticDecorator targetView) {
        return this.createDomainBasedEdge(source, target, type, containementReferenceName, sourceView, targetView, null);
    }

    public EObject createDomainBasedEdge(EObject source, EObject target, String type, String containementReferenceName, DSemanticDecorator sourceView, DSemanticDecorator targetView, IDomainBasedEdgeContainerProvider containerProvider) {
        Optional<DDiagram> optionalDDiagram = Optional.ofNullable(sourceView).filter(DDiagramElement.class::isInstance).map(DDiagramElement.class::cast).map(DDiagramElement::getParentDiagram);
        RepresentationQuerier representationQuery = new RepresentationQuerier(optionalDDiagram.orElse(null));
        if (containerProvider == null) {
            containerProvider = new ElementDomainBasedEdgeContainerProvider((IEditableChecker)new EditableChecker());
        }
        CreationStatus status = this.buildBasedEdgeCreator(source, containerProvider).createDomainBasedEdge(source, target, type, containementReferenceName, (IViewQuerier)representationQuery, (Object)sourceView, (Object)targetView);
        EObject result = status.getElement();
        if (status.getState() == State.FAILED) {
            Activator.log.warn("Creation failed : " + status.getMessage());
        } else if (result != null) {
            this.createAdditionalViews(result, sourceView, targetView);
            Session session = SessionManager.INSTANCE.getSession(source);
            this.createEdgeView(result, (DDiagramElement)sourceView, session);
        }
        return result;
    }

    protected void createAdditionalViews(EObject semanticEdge, DSemanticDecorator sourceView, DSemanticDecorator targetView) {
    }

    private ElementBasedEdgeCreator buildBasedEdgeCreator(EObject source, IDomainBasedEdgeContainerProvider containerProvider) {
        ECrossReferenceAdapter crossRef = this.getECrossReferenceAdapter(source);
        ElementBasedEdgeCreator baseEdgeCreator = new ElementBasedEdgeCreator(containerProvider, (IDomainBasedEdgeInitializer)new ElementDomainBasedEdgeInitializer(), (IElementConfigurer)new ElementConfigurer(), (IFeatureModifier)new ElementFeatureModifier(crossRef, (IEditableChecker)new EditableChecker()));
        return baseEdgeCreator;
    }
}

