/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.labelprovider.service.impl;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.services.labelprovider.Activator;
import org.eclipse.papyrus.infra.services.labelprovider.service.ContextualLabelProvider;
import org.eclipse.papyrus.infra.services.labelprovider.service.ExtensibleLabelProvider;
import org.eclipse.papyrus.infra.services.labelprovider.service.IFilteredLabelProvider;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;

public class LabelProviderServiceImpl
implements LabelProviderService {
    private final Map<String, SharedExtensibleLabelProvider> labelProviders = new HashMap<String, SharedExtensibleLabelProvider>();
    public static final String EXTENSION_ID = "org.eclipse.papyrus.infra.services.labelprovider.labelProvider";

    public LabelProviderServiceImpl() {
        IConfigurationElement[] config = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_ID);
        this.readContexts(config);
        this.readLabelProviders(config);
    }

    public void init(ServicesRegistry servicesRegistry) throws ServiceException {
    }

    public void startService() throws ServiceException {
    }

    private void readContexts(IConfigurationElement[] config) {
        IConfigurationElement[] iConfigurationElementArray = config;
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            try {
                if ("context".equals(e.getName())) {
                    String contextId = e.getAttribute("id");
                    if (contextId == null) {
                        Activator.log.warn("The plug-in " + String.valueOf(e.getContributor()) + " contributed an invalid extension for org.eclipse.papyrus.infra.services.labelprovider.labelProvider. The context id must be set");
                    } else if (this.labelProviders.containsKey(contextId)) {
                        Activator.log.warn("The context " + contextId + " is already contributed");
                    } else {
                        this.labelProviders.put(contextId, new SharedExtensibleLabelProvider());
                    }
                }
            }
            catch (Exception ex) {
                Activator.log.error("The plugin " + String.valueOf(e.getContributor()) + " contributed an invalid extension for org.eclipse.papyrus.infra.services.labelprovider.labelProvider", (Throwable)ex);
            }
            ++n2;
        }
        if (!this.labelProviders.containsKey("default")) {
            this.labelProviders.put("default", new SharedExtensibleLabelProvider());
        }
    }

    private void readLabelProviders(IConfigurationElement[] config) {
        IConfigurationElement[] iConfigurationElementArray = config;
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            try {
                if ("labelProvider".equals(e.getName())) {
                    IFilteredLabelProvider provider = (IFilteredLabelProvider)e.createExecutableExtension("provider");
                    if (provider == null) {
                        Activator.log.warn("The labelProvider class is required");
                    } else {
                        int priority = Integer.parseInt(e.getAttribute("priority"));
                        IConfigurationElement[] contextElements = e.getChildren("labelProviderContext");
                        if (contextElements.length == 0) {
                            for (ExtensibleLabelProvider extensibleLabelProvider : this.labelProviders.values()) {
                                extensibleLabelProvider.registerProvider(priority, provider);
                            }
                        } else {
                            IConfigurationElement[] iConfigurationElementArray2 = contextElements;
                            int n3 = contextElements.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                IConfigurationElement iConfigurationElement = iConfigurationElementArray2[n4];
                                String context = iConfigurationElement.getAttribute("context");
                                if (context != null) {
                                    ExtensibleLabelProvider labelProvider = this.labelProviders.get(context);
                                    if (labelProvider == null) {
                                        Activator.log.warn("Unknown label provider context: " + context);
                                    } else {
                                        labelProvider.registerProvider(priority, provider);
                                    }
                                } else {
                                    Activator.log.warn("The context for label provider " + e.getAttribute("provider") + " is null");
                                }
                                ++n4;
                            }
                        }
                    }
                }
            }
            catch (ClassCastException ex) {
                Activator.log.warn("The plug-in " + String.valueOf(e.getContributor()) + " contributed an invalid extension for org.eclipse.papyrus.infra.services.labelprovider.labelProvider. The labelProvider must implement IFilteredLabelProvider");
            }
            catch (Exception ex) {
                Activator.log.error("The plugin " + String.valueOf(e.getContributor()) + " contributed an invalid extension for org.eclipse.papyrus.infra.services.labelprovider.labelProvider", (Throwable)ex);
            }
            ++n2;
        }
    }

    public void disposeService() throws ServiceException {
        for (SharedExtensibleLabelProvider provider : this.labelProviders.values()) {
            provider.doDispose();
        }
        this.labelProviders.clear();
    }

    @Override
    public ILabelProvider getLabelProvider() {
        return this.getLabelProvider("default");
    }

    @Override
    public ILabelProvider getLabelProvider(String context) {
        if (context == null) {
            return this.getLabelProvider();
        }
        if (!this.labelProviders.containsKey(context)) {
            Activator.log.warn("Unknown label provider context: " + context + ". The default label provider will be used");
            if ("default".equals(context)) {
                return new LabelProvider();
            }
            return this.getLabelProvider();
        }
        return this.labelProviders.get(context);
    }

    @Override
    public ILabelProvider getLabelProvider(String context, Object contextElement) {
        ILabelProvider provider = this.getLabelProvider(context);
        if (provider instanceof ContextualLabelProvider) {
            ((ContextualLabelProvider)provider).setContext(contextElement);
        }
        return provider;
    }

    @Override
    public ILabelProvider getLabelProvider(Object contextElement) {
        ILabelProvider provider = this.getLabelProvider();
        if (provider instanceof ContextualLabelProvider) {
            ((ContextualLabelProvider)provider).setContext(contextElement);
        }
        return provider;
    }

    private class SharedExtensibleLabelProvider
    extends ExtensibleLabelProvider {
        private SharedExtensibleLabelProvider() {
        }

        @Override
        public void dispose() {
        }

        public void doDispose() {
            super.dispose();
        }
    }
}

