/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.utils;

import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.manager.table.MatrixTableWidgetModelManager;
import org.eclipse.papyrus.infra.nattable.manager.table.NattableModelManager;
import org.eclipse.papyrus.infra.nattable.manager.table.TreeNattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.selection.ISelectionExtractor;
import org.eclipse.papyrus.infra.nattable.utils.TableHelper;

public class NattableModelManagerFactory {
    public static final NattableModelManagerFactory INSTANCE = new NattableModelManagerFactory();

    private NattableModelManagerFactory() {
    }

    public INattableModelManager createNatTableModelManager(Table table, ISelectionExtractor selectionExtractor) {
        return this.createNatTableModelManager(table, selectionExtractor, true);
    }

    public INattableModelManager createNatTableModelManager(Table table, ISelectionExtractor selectionExtractor, boolean initializeListeners) {
        if (TableHelper.isMatrixTreeTable(table)) {
            return new MatrixTableWidgetModelManager(table, selectionExtractor, initializeListeners);
        }
        if (TableHelper.isTreeTable(table)) {
            return new TreeNattableModelManager(table, selectionExtractor, initializeListeners);
        }
        return new NattableModelManager(table, selectionExtractor, initializeListeners);
    }
}

