/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.emf.facet.custom.sdk.ui.internal.util.wizard.page;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.emf.facet.custom.sdk.ui.internal.Messages;
import org.eclipse.papyrus.emf.facet.custom.sdk.ui.internal.wizard.page.ICreateCustomizationWizardPage;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;

public class CreateCustomizationWizardPage
extends WizardNewFileCreationPage
implements ICreateCustomizationWizardPage {
    private static final String FILE_EXTENSION = "custom";
    private static final String MODEL_BASE = "My";

    public CreateCustomizationWizardPage(String pageName, IStructuredSelection selection) {
        super(pageName, selection);
        Object selectedElement;
        this.setTitle(Messages.CreateCustomizationWizardImpl_customization);
        this.setDescription(Messages.CreateCustomizationWizardImpl_Create_new_customization);
        this.setFileName("My.custom");
        if (selection != null && !selection.isEmpty() && (selectedElement = selection.iterator().next()) instanceof IResource) {
            this.getResourceParent(selectedElement);
        }
    }

    private void getResourceParent(Object selectedElement) {
        IResource selectedResource = (IResource)selectedElement;
        if (selectedResource.getType() == 1) {
            selectedResource = selectedResource.getParent();
        }
        if (selectedResource instanceof IFolder || selectedResource instanceof IProject) {
            this.setContainerFullPath(selectedResource.getFullPath());
            String modelFileExt = FILE_EXTENSION;
            Object modelFilename = "My.custom";
            int i = 1;
            while (((IContainer)selectedResource).findMember((String)modelFilename) != null) {
                modelFilename = MODEL_BASE + i + ".custom";
                ++i;
            }
            this.setFileName((String)modelFilename);
        }
    }

    protected boolean validatePage() {
        boolean valid = super.validatePage();
        if (valid) {
            String extension = new Path(this.getFileName()).getFileExtension();
            if (extension == null || !FILE_EXTENSION.equalsIgnoreCase(extension)) {
                this.setErrorMessage(Messages.CreateCustomizationWizardImpl_File_extension_restriction);
                valid = false;
            }
            IPath iPath = this.getContainerFullPath();
        }
        return valid;
    }

    @Override
    public IFile getModelFile() {
        return ResourcesPlugin.getWorkspace().getRoot().getFile(this.getContainerFullPath().append(this.getFileName()));
    }
}

