/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.profilemigration.ui.dialogs;

import java.util.List;
import java.util.Map;
import org.eclipse.papyrus.toolsmiths.profilemigration.ui.dialogs.AbstractProfileMigrationDialog;
import org.eclipse.papyrus.uml.tools.providers.UMLLabelProvider;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Stereotype;

public abstract class AbstractTabsProfileMigrationDialog
extends AbstractProfileMigrationDialog {
    protected Map<Element, List<Stereotype>> mapElementToStereotype;

    public AbstractTabsProfileMigrationDialog(Shell shell, String title, String prefConst, Map<Element, List<Stereotype>> mapElementToStereotype) {
        super(shell, title, prefConst);
        this.mapElementToStereotype = mapElementToStereotype;
    }

    @Override
    protected void getMigrationActionSectionContent(Composite body, FormToolkit toolkit) {
        TabFolder tabFolder = new TabFolder(body, 0);
        UMLLabelProvider labelProvider = new UMLLabelProvider();
        for (Element element : this.mapElementToStereotype.keySet()) {
            TabItem tabItem = new TabItem(tabFolder, 0);
            tabItem.setText(labelProvider.getText((Object)element));
            tabItem.setControl(this.getTabElementControl(element, tabFolder));
        }
    }

    private Control getTabElementControl(Element element, TabFolder tabFolder) {
        Composite composite = new Composite((Composite)tabFolder, 0);
        composite.setLayout((Layout)new FillLayout(256));
        if (!this.mapElementToStereotype.isEmpty()) {
            List<Stereotype> stereotypes = this.mapElementToStereotype.get(element);
            if (stereotypes.size() == 1) {
                this.getMigrationActionTabContent(composite, element, stereotypes.get(0));
            } else if (stereotypes.size() > 1) {
                TabFolder tabFolder2 = new TabFolder(composite, 0);
                UMLLabelProvider labelProvider = new UMLLabelProvider();
                for (Stereotype stereotype : stereotypes) {
                    TabItem tabItem = new TabItem(tabFolder2, 0);
                    tabItem.setText(labelProvider.getText((Object)stereotype));
                    tabItem.setControl(this.getTabControlStereotype(element, stereotype, tabFolder2));
                }
            }
        }
        return composite;
    }

    private Control getTabControlStereotype(Element element, Stereotype stereotype, TabFolder tabFolder2) {
        Composite composite = new Composite((Composite)tabFolder2, 0);
        composite.setLayout((Layout)new FillLayout(256));
        this.getMigrationActionTabContent(composite, element, stereotype);
        return composite;
    }

    protected abstract void getMigrationActionTabContent(Composite var1, Element var2, Stereotype var3);
}

