/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.junit.utils.diagram.creation.graphical.checker;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.papyrus.sirius.junit.utils.diagram.creation.graphical.checker.GraphicalOwnerUtils;
import org.eclipse.papyrus.sirius.junit.utils.diagram.creation.graphical.checker.IGraphicalRepresentationElementCreationChecker;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.junit.Assert;

public abstract class AbstractGraphicalCreationChecker
implements IGraphicalRepresentationElementCreationChecker {
    protected static final int DEFAULT_CREATED_ELEMENTS_NUMBER = 1;
    protected final Diagram diagram;
    protected final DDiagram semanticDiagram;
    protected final int nbSiriusDiagramTotalElement;
    protected final EObject graphicalParent;
    protected final int nbGraphicalContainerChildren;
    protected int expectedAdditionalChildren = 1;
    protected int expectedCreatedElements = 1;

    public AbstractGraphicalCreationChecker(Diagram diagram, EObject graphicalParent) {
        this.diagram = diagram;
        this.semanticDiagram = (DDiagram)this.diagram.getElement();
        this.nbSiriusDiagramTotalElement = this.semanticDiagram.getDiagramElements().size();
        this.graphicalParent = graphicalParent;
        this.nbGraphicalContainerChildren = this.getGraphicalOwnerChildrenSize();
    }

    protected int getGraphicalOwnerChildrenSize() {
        List<? extends DDiagramElement> children = GraphicalOwnerUtils.getChildren(this.graphicalParent);
        return children.size();
    }

    @Override
    public void validateRepresentationElement(DRepresentationElement createdElementRepresentation) {
        this.checkCreatedElementInstanceOf(createdElementRepresentation);
        this.checkCreatedElementMapping(createdElementRepresentation);
        this.checkElementsSizes("creation", true);
    }

    protected abstract void checkCreatedElementInstanceOf(DRepresentationElement var1);

    protected abstract void checkCreatedElementMapping(DRepresentationElement var1);

    @Override
    public void validateAfterUndo() {
        this.checkElementsSizes("undo", false);
    }

    @Override
    public void validateAfterRedo() {
        this.checkElementsSizes("redo", true);
    }

    protected void checkElementsSizes(String phase, boolean done) {
        int newChildren = this.getExpectedAdditionalChildren();
        int newElements = this.getNumberOfExpectedCreatedElement();
        if (!done) {
            newChildren = 0;
            newElements = 0;
        }
        Assert.assertEquals((String)("Unexpected number of additional elements in parent on " + phase), (long)newChildren, (long)(this.getGraphicalOwnerChildrenSize() - this.nbGraphicalContainerChildren));
        EList semanticChildren = this.semanticDiagram.getDiagramElements();
        Assert.assertEquals((String)("Unexpected number of additional elements in Diagram on " + phase), (long)newElements, (long)(semanticChildren.size() - this.nbSiriusDiagramTotalElement));
    }

    public int getExpectedAdditionalChildren() {
        return this.expectedAdditionalChildren;
    }

    public void setExpectedAdditionalChildren(int expectedChildren) {
        this.expectedAdditionalChildren = expectedChildren;
    }

    public int getNumberOfExpectedCreatedElement() {
        return this.expectedCreatedElements;
    }

    public void setExpectedCreatedElements(int expectedElements) {
        this.expectedCreatedElements = expectedElements;
    }
}

