/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.junit.util.diagram;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.sirius.junit.util.diagram.AbstractSiriusDiagramTests;
import org.eclipse.papyrus.sirius.junit.utils.diagram.creation.graphical.checker.GraphicalOwnerUtils;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.junit.Assert;

public class AbstractDeleteSemanticNodeTest
extends AbstractSiriusDiagramTests {
    protected void deleteNode(String elementNameToDestroy, String mappingTypeName, boolean isSynchronized) {
        this.deleteNode(elementNameToDestroy, mappingTypeName, (EObject)this.getDDiagram(), isSynchronized);
    }

    protected void deleteNode(String elementNameToDestroy, String mappingTypeName, EObject graphicalContainer, NamedElement semanticContainer, boolean isSynchronized) {
        NamedElement parentElement = null;
        if (semanticContainer == null) {
            Package rootModel = this.getModel();
            if (graphicalContainer instanceof DSemanticDiagram) {
                parentElement = rootModel;
            } else if (graphicalContainer instanceof DDiagramElementContainer) {
                parentElement = (NamedElement)((DRepresentationElement)graphicalContainer).getSemanticElements().get(0);
            }
        } else {
            parentElement = semanticContainer;
        }
        int nbContainerElementInitial = GraphicalOwnerUtils.getGraphicalOwnerChildrenSize(graphicalContainer);
        this.checkSiriusDiagramSynchronization(isSynchronized);
        String elementType = null;
        Object semanticElement = this.getMemberFromParent(parentElement, elementNameToDestroy);
        if (semanticElement != null) {
            elementType = semanticElement.getClass().getSimpleName();
        }
        AbstractDNode nodeToDelete = this.getNodeFromContainer(elementNameToDestroy, mappingTypeName, graphicalContainer, (EObject)parentElement);
        Assert.assertNotNull((String)"Element to delete not found on diagram.", (Object)nodeToDelete);
        this.fixture.applySemanticDeletionTool((DDiagramElement)nodeToDelete);
        this.fixture.flushDisplayEvents();
        Assert.assertNull((String)("The UML model must not contain the destroyed " + elementType + " element"), (Object)this.getMemberFromParent(parentElement, elementNameToDestroy));
        Assert.assertEquals((String)("The graphical container must not contains view after destruction of the " + elementType + " element"), (long)(nbContainerElementInitial - 1), (long)GraphicalOwnerUtils.getGraphicalOwnerChildrenSize(graphicalContainer));
        this.fixture.getEditingDomain().getCommandStack().undo();
        this.fixture.flushDisplayEvents();
        Assert.assertNotNull((String)("The UML model must contain the destroyed " + elementType + " element after undoing the destruction"), (Object)this.getMemberFromParent(parentElement, elementNameToDestroy));
        Assert.assertEquals((String)("The graphical container must contain the view of the " + elementType + " element after undoing the destruction"), (long)nbContainerElementInitial, (long)GraphicalOwnerUtils.getGraphicalOwnerChildrenSize(graphicalContainer));
        this.fixture.getEditingDomain().getCommandStack().redo();
        this.fixture.flushDisplayEvents();
        Assert.assertNull((String)("The UML model must not contain the destroyed " + elementType + " element after redoing the destruction"), (Object)this.getMemberFromParent(parentElement, elementNameToDestroy));
        Assert.assertEquals((String)("The graphical container must not contain the view of the " + elementType + " element after redoing the destruction"), (long)(nbContainerElementInitial - 1), (long)GraphicalOwnerUtils.getGraphicalOwnerChildrenSize(graphicalContainer));
    }

    protected void deleteNode(String elementNameToDestroy, String mappingTypeName, EObject graphicalContainer, boolean isSynchronized) {
        this.deleteNode(elementNameToDestroy, mappingTypeName, graphicalContainer, null, isSynchronized);
    }

    private Object getMemberFromParent(NamedElement parentElement, String elementNameToDestroy) {
        NamedElement element = null;
        if (parentElement instanceof Model) {
            element = ((Model)parentElement).getMember(elementNameToDestroy);
        } else {
            for (EObject child : parentElement.eContents()) {
                if (!(child instanceof NamedElement) || !elementNameToDestroy.equals(((NamedElement)child).getName())) continue;
                element = (NamedElement)child;
            }
        }
        return element;
    }
}

