/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.ui.architecture.preferences;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.ui.CommonUIPlugin;
import org.eclipse.emf.common.ui.dialogs.WorkspaceResourceDialog;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ArchitectureModelSelectDialog
extends Dialog {
    protected static final int CONTROL_OFFSET = 10;
    protected String title;
    protected int style;
    protected Text uriField;
    protected String uriText;
    protected String[] initialSelection;

    public ArchitectureModelSelectDialog(Shell parent, String title, String[] initialSelection) {
        super(parent);
        this.title = title != null ? title : CommonUIPlugin.INSTANCE.getString("_UI_ResourceDialog_title");
        this.style = 4098;
        this.setShellStyle(this.getShellStyle() | 0x400 | 0x10);
        this.initialSelection = initialSelection;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.title);
    }

    protected Control createDialogArea(Composite parent) {
        FormData data;
        Composite composite = (Composite)super.createDialogArea(parent);
        FormLayout layout = new FormLayout();
        composite.setLayout((Layout)layout);
        GridData data2 = new GridData();
        data2.verticalAlignment = 4;
        data2.grabExcessVerticalSpace = true;
        data2.horizontalAlignment = 4;
        data2.grabExcessHorizontalSpace = true;
        if (!EMFPlugin.IS_RESOURCES_BUNDLE_AVAILABLE) {
            data2.widthHint = 330;
        }
        composite.setLayoutData((Object)data2);
        Composite buttonComposite = new Composite(composite, 0);
        Label resourceURILabel = new Label(composite, 16384);
        resourceURILabel.setText(CommonUIPlugin.INSTANCE.getString("_UI_ResourceURIs_label"));
        FormData data3 = new FormData();
        data3.left = new FormAttachment(0, 10);
        data3.top = new FormAttachment(0, 10);
        resourceURILabel.setLayoutData((Object)data3);
        data3 = new FormData();
        data3.top = new FormAttachment((Control)resourceURILabel, 10, 0x1000000);
        data3.left = new FormAttachment((Control)resourceURILabel, 10);
        data3.right = new FormAttachment(100, -10);
        buttonComposite.setLayoutData((Object)data3);
        buttonComposite.setLayout((Layout)new FormLayout());
        this.uriField = new Text(composite, 2048);
        data3 = new FormData();
        data3.top = new FormAttachment((Control)buttonComposite, 10);
        data3.left = new FormAttachment(0, 10);
        data3.right = new FormAttachment(100, -10);
        this.uriField.setLayoutData((Object)data3);
        this.uriField.setText(String.join((CharSequence)" ", this.initialSelection));
        Button browseFileSystemButton = new Button(buttonComposite, 8);
        browseFileSystemButton.setText(CommonUIPlugin.INSTANCE.getString("_UI_BrowseFileSystem_label"));
        this.prepareBrowseFileSystemButton(browseFileSystemButton);
        if (EMFPlugin.IS_RESOURCES_BUNDLE_AVAILABLE) {
            Button browseWorkspaceButton = new Button(buttonComposite, 8);
            data = new FormData();
            data.right = new FormAttachment(100);
            browseWorkspaceButton.setLayoutData((Object)data);
            data = new FormData();
            data.right = new FormAttachment((Control)browseWorkspaceButton, -10);
            browseFileSystemButton.setLayoutData((Object)data);
            browseWorkspaceButton.setText(CommonUIPlugin.INSTANCE.getString("_UI_BrowseWorkspace_label"));
            this.prepareBrowseWorkspaceButton(browseWorkspaceButton);
        } else {
            FormData data4 = new FormData();
            data4.right = new FormAttachment(100);
            browseFileSystemButton.setLayoutData((Object)data4);
        }
        Label separatorLabel = new Label(composite, 258);
        data = new FormData();
        data.top = new FormAttachment((Control)this.uriField, 15);
        data.left = new FormAttachment(0, -10);
        data.right = new FormAttachment(100, 10);
        separatorLabel.setLayoutData((Object)data);
        composite.setTabList(new Control[]{this.uriField, buttonComposite});
        return composite;
    }

    protected void prepareBrowseFileSystemButton(Button browseFileSystemButton) {
        browseFileSystemButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FileDialog fileDialog = new FileDialog(ArchitectureModelSelectDialog.this.getShell(), ArchitectureModelSelectDialog.this.style);
                fileDialog.open();
                String filterPath = fileDialog.getFilterPath();
                String[] fileNames = fileDialog.getFileNames();
                StringBuffer uris = new StringBuffer();
                int i = 0;
                int len = fileNames.length;
                while (i < len) {
                    uris.append(URI.createFileURI((String)(filterPath + File.separator + fileNames[i])).toString());
                    uris.append("  ");
                    ++i;
                }
                ArchitectureModelSelectDialog.this.uriField.setText((ArchitectureModelSelectDialog.this.uriField.getText() + "  " + uris.toString()).trim());
            }
        });
    }

    protected void prepareBrowseWorkspaceButton(Button browseWorkspaceButton) {
        browseWorkspaceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                StringBuffer uris = new StringBuffer();
                IFile[] files = WorkspaceResourceDialog.openFileSelection((Shell)ArchitectureModelSelectDialog.this.getShell(), null, null, (boolean)true, null, null);
                int i = 0;
                int len = files.length;
                while (i < len) {
                    uris.append(URI.createPlatformResourceURI((String)files[i].getFullPath().toString(), (boolean)true));
                    uris.append("  ");
                    ++i;
                }
                ArchitectureModelSelectDialog.this.uriField.setText((ArchitectureModelSelectDialog.this.uriField.getText() + "  " + uris.toString()).trim());
            }
        });
    }

    protected void okPressed() {
        this.uriText = this.getURIText();
        super.okPressed();
    }

    public String getURIText() {
        return this.uriField != null && !this.uriField.isDisposed() ? this.uriField.getText() : this.uriText;
    }

    public List<URI> getURIs() {
        ArrayList<URI> uris = new ArrayList<URI>();
        if (this.getURIText() != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(this.getURIText());
            while (stringTokenizer.hasMoreTokens()) {
                String uri = stringTokenizer.nextToken();
                uris.add(URI.createURI((String)uri));
            }
        }
        return uris;
    }
}

