/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.properties.contexts.util;

import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLLoad;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.SAXXMIHandler;
import org.eclipse.emf.ecore.xmi.impl.XMIHelperImpl;
import org.eclipse.emf.ecore.xmi.impl.XMILoadImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.papyrus.infra.properties.contexts.Annotation;
import org.xml.sax.helpers.DefaultHandler;

public class ContextsResourceImpl
extends XMIResourceImpl {
    public ContextsResourceImpl(URI uri) {
        super(uri);
    }

    protected boolean useUUIDs() {
        return true;
    }

    protected XMLHelper createXMLHelper() {
        return new ContextsXMIHelper();
    }

    protected XMLLoad createXMLLoad() {
        return new ContextsXMILoad(this.createXMLHelper());
    }

    boolean isAnnotationDetailURI(EObject object, EStructuralFeature feature) {
        return feature == EcorePackage.Literals.ESTRING_TO_STRING_MAP_ENTRY__VALUE && "model".equals(((Map.Entry)object).getKey()) && object.eContainer() instanceof Annotation;
    }

    void resolveURIs(Annotation annotation) {
        for (Map.Entry detail : annotation.getDetails()) {
            URI uri;
            String rawValue;
            if (!"model".equals(detail.getKey()) || (rawValue = (String)detail.getValue()) == null || rawValue.isBlank() || !(uri = URI.createURI((String)rawValue, (boolean)true)).isRelative()) continue;
            uri = uri.resolve(this.getURI());
            detail.setValue(uri.toString());
        }
    }

    private class ContextsXMIHandler
    extends SAXXMIHandler {
        ContextsXMIHandler(XMLResource xmiResource, XMLHelper helper, Map<?, ?> options) {
            super(xmiResource, helper, options);
        }

        public void endElement(String uri, String localName, String name) {
            EObject object = this.objects.peekEObject();
            if (object instanceof Annotation) {
                ContextsResourceImpl.this.resolveURIs((Annotation)object);
            }
            super.endElement(uri, localName, name);
        }
    }

    private class ContextsXMIHelper
    extends XMIHelperImpl {
        ContextsXMIHelper() {
            super((XMLResource)ContextsResourceImpl.this);
        }

        public Object getValue(EObject object, EStructuralFeature feature) {
            String rawValue;
            if (ContextsResourceImpl.this.isAnnotationDetailURI(object, feature) && (rawValue = (String)((Map.Entry)object).getValue()) != null && !rawValue.isBlank()) {
                URI uri = URI.createURI((String)rawValue);
                URI base = ContextsResourceImpl.this.getURI();
                return uri.deresolve(base).toString();
            }
            return super.getValue(object, feature);
        }
    }

    private class ContextsXMILoad
    extends XMILoadImpl {
        ContextsXMILoad(XMLHelper helper) {
            super(helper);
        }

        protected DefaultHandler makeDefaultHandler() {
            return new ContextsXMIHandler(this.resource, this.helper, this.options);
        }
    }
}

