/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.uml.diagram.common.services;

import java.util.List;
import java.util.Optional;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.sirius.uml.diagram.common.core.services.AbstractDiagramServices;
import org.eclipse.papyrus.sirius.uml.diagram.common.core.services.EditableChecker;
import org.eclipse.papyrus.sirius.uml.diagram.common.core.services.RepresentationQuerier;
import org.eclipse.papyrus.uml.domain.services.IEditableChecker;
import org.eclipse.papyrus.uml.domain.services.IViewQuerier;
import org.eclipse.papyrus.uml.domain.services.edges.ElementDomainBasedEdgeContainerProvider;
import org.eclipse.papyrus.uml.domain.services.edges.IDomainBasedEdgeContainerProvider;
import org.eclipse.papyrus.uml.domain.services.reconnect.ElementDomainBasedEdgeReconnectSourceBehaviorProvider;
import org.eclipse.papyrus.uml.domain.services.reconnect.ElementDomainBasedEdgeReconnectTargetBehaviorProvider;
import org.eclipse.papyrus.uml.domain.services.reconnect.ElementDomainBasedEdgeReconnectionSourceChecker;
import org.eclipse.papyrus.uml.domain.services.reconnect.ElementDomainBasedEdgeReconnectionTargetChecker;
import org.eclipse.papyrus.uml.domain.services.status.CheckStatus;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.diagram.description.tool.CreateEdgeView;
import org.eclipse.sirius.diagram.description.tool.CreateView;
import org.eclipse.sirius.diagram.description.tool.ToolFactory;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;

public class ReconnectServices
extends AbstractDiagramServices {
    public void reconnectSource(EObject semanticElementEdge, EObject oldSource, EObject newSource, DSemanticDecorator newSourceView) {
        RepresentationQuerier representationQuery = this.createRepresentationQuerier(newSourceView);
        CheckStatus reconnectSourceStatus = new ElementDomainBasedEdgeReconnectSourceBehaviorProvider((IEditableChecker)new EditableChecker(), (IViewQuerier)representationQuery).reconnectSource(semanticElementEdge, oldSource, newSource, (Object)newSourceView);
        if (reconnectSourceStatus.isValid() && this.isCompartment(newSourceView)) {
            Session session = SessionManager.INSTANCE.getSession(semanticElementEdge);
            DDiagram containerView = ((DDiagramElement)newSourceView).getParentDiagram();
            List<DiagramElementMapping> semanticElementMappings = this.getMappings(semanticElementEdge, (DSemanticDecorator)containerView, session);
            CreateEdgeView createEdgeViewOp = ToolFactory.eINSTANCE.createCreateEdgeView();
            for (DiagramElementMapping semanticElementMapping : semanticElementMappings) {
                if (!(semanticElementMapping instanceof EdgeMapping)) continue;
                DiagramElementMapping tmpSemanticElementMapping = semanticElementMapping;
                createEdgeViewOp.setMapping(tmpSemanticElementMapping);
                createEdgeViewOp.setContainerViewExpression("aql:sourceView.eContainer(diagram::DDiagram)");
                createEdgeViewOp.setSourceExpression("aql:target");
                createEdgeViewOp.setTargetExpression("aql:element.getTargets()->first()");
                this.executeCreateViewOperation(semanticElementEdge, session, (DSemanticDecorator)containerView, (CreateView)createEdgeViewOp);
            }
        }
    }

    public boolean canReconnectSource(EObject semanticElementEdge, DSemanticDecorator edgeView, EObject oldSource, EObject newSource, DSemanticDecorator newSourceView) {
        return this.canReconnectSource(semanticElementEdge, edgeView, oldSource, newSource, newSourceView, (IDomainBasedEdgeContainerProvider)new ElementDomainBasedEdgeContainerProvider((IEditableChecker)new EditableChecker()));
    }

    public boolean canReconnectSource(EObject semanticElementEdge, DSemanticDecorator edgeView, EObject oldSource, EObject newSource, DSemanticDecorator newSourceView, IDomainBasedEdgeContainerProvider domainBasedEdgeContainerProvider) {
        RepresentationQuerier representationQuery = this.createRepresentationQuerier(newSourceView);
        Optional<EdgeTarget> optionalTargetView = Optional.ofNullable(edgeView).filter(DEdge.class::isInstance).map(DEdge.class::cast).map(DEdge::getTargetNode);
        CheckStatus canReconnectStatus = new ElementDomainBasedEdgeReconnectionSourceChecker((IEditableChecker)new EditableChecker(), (IViewQuerier)representationQuery).canReconnect(semanticElementEdge, oldSource, newSource, (Object)newSourceView, optionalTargetView.orElse(null));
        boolean canReconnectSource = canReconnectStatus.isValid();
        if (canReconnectSource) {
            EObject container;
            Optional<EObject> optionalTarget = optionalTargetView.filter(DSemanticDecorator.class::isInstance).map(DSemanticDecorator.class::cast).map(DSemanticDecorator::getTarget);
            canReconnectSource = optionalTargetView.isPresent() && optionalTarget.isPresent() ? (container = domainBasedEdgeContainerProvider.getContainer(newSource, optionalTarget.get(), semanticElementEdge, (IViewQuerier)representationQuery, (Object)newSourceView, (Object)optionalTargetView.get())) != null : false;
        }
        return canReconnectSource;
    }

    public void reconnectTarget(EObject semanticElementEdge, EObject oldTarget, EObject newTarget, DSemanticDecorator newTargetView) {
        RepresentationQuerier representationQuery = this.createRepresentationQuerier(newTargetView);
        CheckStatus reconnectTargetStatus = new ElementDomainBasedEdgeReconnectTargetBehaviorProvider((IViewQuerier)representationQuery).reconnectTarget(semanticElementEdge, oldTarget, newTarget, (Object)newTargetView);
        if (reconnectTargetStatus.isValid() && this.isCompartment(newTargetView)) {
            Session session = SessionManager.INSTANCE.getSession(semanticElementEdge);
            DDiagram containerView = ((DDiagramElement)newTargetView).getParentDiagram();
            List<DiagramElementMapping> semanticElementMappings = this.getMappings(semanticElementEdge, (DSemanticDecorator)containerView, session);
            CreateEdgeView createEdgeViewOp = ToolFactory.eINSTANCE.createCreateEdgeView();
            for (DiagramElementMapping semanticElementMapping : semanticElementMappings) {
                if (!(semanticElementMapping instanceof EdgeMapping)) continue;
                DiagramElementMapping tmpSemanticElementMapping = semanticElementMapping;
                createEdgeViewOp.setMapping(tmpSemanticElementMapping);
                createEdgeViewOp.setContainerViewExpression("aql:targetView.eContainer(diagram::DDiagram)");
                createEdgeViewOp.setSourceExpression("aql:element.getSource()");
                createEdgeViewOp.setTargetExpression("aql:target");
                this.executeCreateViewOperation(semanticElementEdge, session, (DSemanticDecorator)containerView, (CreateView)createEdgeViewOp);
            }
        }
    }

    public boolean canReconnectTarget(EObject semanticElementEdge, DSemanticDecorator edgeView, EObject oldTarget, EObject newTarget, DSemanticDecorator newTargetView) {
        return this.canReconnectTarget(semanticElementEdge, edgeView, oldTarget, newTarget, newTargetView, (IDomainBasedEdgeContainerProvider)new ElementDomainBasedEdgeContainerProvider((IEditableChecker)new EditableChecker()));
    }

    public boolean canReconnectTarget(EObject semanticElementEdge, DSemanticDecorator edgeView, EObject oldTarget, EObject newTarget, DSemanticDecorator newTargetView, IDomainBasedEdgeContainerProvider domainBasedEdgeContainerProvider) {
        RepresentationQuerier representationQuery = this.createRepresentationQuerier(newTargetView);
        Optional<EdgeTarget> optionalSourceView = Optional.ofNullable(edgeView).filter(DEdge.class::isInstance).map(DEdge.class::cast).map(DEdge::getSourceNode);
        CheckStatus canReconnectStatus = new ElementDomainBasedEdgeReconnectionTargetChecker((IEditableChecker)new EditableChecker(), (IViewQuerier)representationQuery).canReconnect(semanticElementEdge, oldTarget, newTarget, (Object)newTargetView, optionalSourceView.orElse(null));
        boolean canReconnectTarget = canReconnectStatus.isValid();
        if (canReconnectTarget) {
            EObject container;
            Optional<EObject> optionalSource = optionalSourceView.filter(DSemanticDecorator.class::isInstance).map(DSemanticDecorator.class::cast).map(DSemanticDecorator::getTarget);
            canReconnectTarget = optionalSourceView.isPresent() && optionalSource.isPresent() ? (container = domainBasedEdgeContainerProvider.getContainer(optionalSource.get(), newTarget, semanticElementEdge, (IViewQuerier)representationQuery, (Object)optionalSourceView.get(), (Object)newTargetView)) != null : false;
        }
        return canReconnectTarget;
    }

    private RepresentationQuerier createRepresentationQuerier(DSemanticDecorator view) {
        Optional<DDiagram> optionalDDiagram = Optional.ofNullable(view).filter(DDiagramElement.class::isInstance).map(DDiagramElement.class::cast).map(DDiagramElement::getParentDiagram);
        RepresentationQuerier representationQuery = new RepresentationQuerier(optionalDDiagram.orElse(null));
        return representationQuery;
    }
}

