/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.junit.util.diagram;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.sirius.junit.util.diagram.AbstractSiriusDiagramTests;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.DragAndDropTarget;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.junit.Assert;

public abstract class AbstractGraphicalDropNodeTests
extends AbstractSiriusDiagramTests {
    protected void dropElementIntoContainer(String elementToDrop, String graphicalOwnerName, String containerMappingType, String compartmentMappingType, String dropToolId, String expectedMappingType) {
        this.dropElementIntoContainer(elementToDrop, graphicalOwnerName, containerMappingType, compartmentMappingType, dropToolId, expectedMappingType, null, null);
    }

    protected void dropElementIntoContainer(String elementToDrop, String graphicalOwnerName, String containerMappingType, String compartmentMappingType, String dropToolId, String expectedMappingType, String newSemanticOwnerName, String newContainmentFeatureName) {
        this.checkSiriusDiagramSynchronization(false);
        DSemanticDiagram siriusDiagram = this.fixture.getActiveSiriusDiagram();
        Assert.assertNotNull((Object)siriusDiagram);
        Assert.assertFalse((String)"The diagram must be unsynchronized to test drop", (boolean)siriusDiagram.isSynchronized());
        List<DDiagramElement> elementsToDrop = this.getElementsFromDiagramBySemanticName(elementToDrop, expectedMappingType);
        Assert.assertTrue((String)"We should find only one element to drop.", (elementsToDrop.size() == 1 ? 1 : 0) != 0);
        Element rootElement = this.getRootElement();
        Assert.assertTrue((boolean)(rootElement instanceof Namespace));
        Optional<DNodeContainer> optionalContainerNode = this.getElementsFromDiagramBySemanticName(graphicalOwnerName, containerMappingType).stream().filter(DNodeContainer.class::isInstance).map(DNodeContainer.class::cast).findFirst();
        if (optionalContainerNode.isPresent()) {
            NamedElement newSemanticOwner = Optional.ofNullable(newSemanticOwnerName).flatMap(this::getElementByNameFromRoot).orElse(null);
            this.dropInDNodeContainer(optionalContainerNode.get(), compartmentMappingType, dropToolId, expectedMappingType, elementsToDrop.get(0), (Element)newSemanticOwner, newContainmentFeatureName);
        } else {
            Assert.fail((String)String.format("Impossible to find the container matching the given graphical owner '%s' and container mapping '%s'", graphicalOwnerName, containerMappingType));
        }
    }

    protected void dropElementToDiagram(String elementToDrop, String dropToolId, String expectedMappingType, String newContainmentFeatureName) {
        this.checkSiriusDiagramSynchronization(false);
        DSemanticDiagram siriusDiagram = this.fixture.getActiveSiriusDiagram();
        Assert.assertNotNull((Object)siriusDiagram);
        Assert.assertFalse((String)"The diagram must be unsynchronized to test drop", (boolean)siriusDiagram.isSynchronized());
        List<DDiagramElement> elementsToDrop = this.getElementsFromDiagramBySemanticName(elementToDrop, expectedMappingType);
        Assert.assertTrue((String)"We should find only one element to drop.", (elementsToDrop.size() == 1 ? 1 : 0) != 0);
        this.dropNodeInDiagram(dropToolId, expectedMappingType, elementsToDrop.get(0), newContainmentFeatureName);
    }

    protected void dropElementToDiagram(String elementToDrop, String dropToolId, String expectedMappingType) {
        this.dropElementToDiagram(elementToDrop, dropToolId, expectedMappingType, null);
    }

    private final DDiagramElement dropInDNodeContainer(DNodeContainer containerNode, String compartmentMappingType, String dropToolId, String expectedMappingType, DDiagramElement elementToBeDropped, Element newSemanticOwner, String newContainmentFeatureName) {
        Diagram diagram = this.getDiagram();
        Object semanticContainer = newSemanticOwner != null ? newSemanticOwner : containerNode.getTarget();
        Object subNodeContainer = this.isBorderNode(expectedMappingType) ? containerNode : this.getDDiagramElementContainerInContainer(containerNode, compartmentMappingType);
        Assert.assertNotNull((String)NLS.bind((String)"We didn't find the compartment type {0}", (Object)compartmentMappingType), (Object)subNodeContainer);
        int initialSize = subNodeContainer.getElements().size();
        List<DDiagramElement> initialDiagramElements = List.copyOf(subNodeContainer.getElements());
        DDiagram diagramRepresentation = (DDiagram)diagram.getElement();
        EObject semanticDroppedElement = elementToBeDropped.getTarget();
        String containmentFeatureNameToUse = newContainmentFeatureName;
        if (containmentFeatureNameToUse == null) {
            containmentFeatureNameToUse = semanticDroppedElement.eContainmentFeature().getName();
        }
        EStructuralFeature targetContainmentFeature = semanticContainer.eClass().getEStructuralFeature(containmentFeatureNameToUse);
        int containementFeatureSizeBefore = ((List)semanticContainer.eGet(targetContainmentFeature)).size();
        boolean result = this.fixture.applyContainerDropDescriptionTool(diagramRepresentation, dropToolId, (DragAndDropTarget)subNodeContainer, elementToBeDropped);
        Assert.assertTrue((String)"The drop of element failed", (boolean)result);
        this.fixture.flushDisplayEvents();
        Assert.assertEquals((long)(initialSize + 1), (long)subNodeContainer.getElements().size());
        Assert.assertEquals((long)(containementFeatureSizeBefore + 1), (long)((List)semanticContainer.eGet(targetContainmentFeature)).size());
        EList subElements = subNodeContainer.getElements();
        Assert.assertEquals((long)(initialSize + 1), (long)subElements.size());
        DDiagramElement createdElementRepresentation = this.computeCreatedElement(initialDiagramElements, (EList<DDiagramElement>)subNodeContainer.getElements());
        Assert.assertEquals((String)"The mapping is not the expected one", (Object)expectedMappingType, (Object)createdElementRepresentation.getMapping().getName());
        Assert.assertEquals((String)"The created element representation must have 1 associated semantic element", (long)1L, (long)createdElementRepresentation.getSemanticElements().size());
        this.fixture.getEditingDomain().getCommandStack().undo();
        this.fixture.flushDisplayEvents();
        Assert.assertEquals((long)initialSize, (long)subNodeContainer.getElements().size());
        Assert.assertEquals((long)containementFeatureSizeBefore, (long)((List)semanticContainer.eGet(targetContainmentFeature)).size());
        this.fixture.getEditingDomain().getCommandStack().redo();
        this.fixture.flushDisplayEvents();
        Assert.assertEquals((long)(initialSize + 1), (long)subNodeContainer.getElements().size());
        Assert.assertEquals((long)(containementFeatureSizeBefore + 1), (long)((List)semanticContainer.eGet(targetContainmentFeature)).size());
        return this.computeCreatedElement(initialDiagramElements, (EList<DDiagramElement>)subNodeContainer.getElements());
    }

    protected final DDiagramElement dropNodeInDiagram(String dropToolId, String expectedMappingType, DDiagramElement elementToBeDropped, String newContainmentFeatureName) {
        Diagram diagram = this.getDiagram();
        DSemanticDiagram diagramRepresentation = (DSemanticDiagram)diagram.getElement();
        EObject semanticDroppedElement = elementToBeDropped.getTarget();
        EReference containmentFeature = semanticDroppedElement.eContainmentFeature();
        String targetContainmentFeatureName = containmentFeature.getName();
        if (newContainmentFeatureName != null) {
            targetContainmentFeatureName = newContainmentFeatureName;
        }
        EStructuralFeature targetContainmentFeature = diagramRepresentation.getTarget().eClass().getEStructuralFeature(targetContainmentFeatureName);
        int containementFeatureSizeBefore = ((List)diagramRepresentation.getTarget().eGet(targetContainmentFeature)).size();
        int initialDiagramElementsSize = diagramRepresentation.getOwnedDiagramElements().size();
        List<DDiagramElement> initialDiagramElements = List.copyOf(diagramRepresentation.getOwnedDiagramElements());
        boolean result = this.fixture.applyContainerDropDescriptionTool((DDiagram)diagramRepresentation, dropToolId, (DragAndDropTarget)diagramRepresentation, elementToBeDropped);
        Assert.assertTrue((String)"The drop of element failed", (boolean)result);
        this.fixture.flushDisplayEvents();
        Assert.assertEquals((long)(containementFeatureSizeBefore + 1), (long)((List)diagramRepresentation.getTarget().eGet(targetContainmentFeature)).size());
        Assert.assertEquals((long)(initialDiagramElementsSize + 1), (long)diagramRepresentation.getOwnedDiagramElements().size());
        DDiagramElement createdElementRepresentation = this.computeCreatedElement(initialDiagramElements, (EList<DDiagramElement>)diagramRepresentation.getOwnedDiagramElements());
        Assert.assertEquals((String)"The mapping is not the expected one", (Object)expectedMappingType, (Object)createdElementRepresentation.getMapping().getName());
        Assert.assertEquals((String)"The created element representation must have 1 associated semantic element", (long)1L, (long)createdElementRepresentation.getSemanticElements().size());
        this.fixture.getEditingDomain().getCommandStack().undo();
        this.fixture.flushDisplayEvents();
        Assert.assertEquals((long)initialDiagramElementsSize, (long)diagramRepresentation.getOwnedDiagramElements().size());
        Assert.assertEquals((long)containementFeatureSizeBefore, (long)((List)diagramRepresentation.getTarget().eGet(targetContainmentFeature)).size());
        this.fixture.getEditingDomain().getCommandStack().redo();
        this.fixture.flushDisplayEvents();
        Assert.assertEquals((long)(initialDiagramElementsSize + 1), (long)diagramRepresentation.getOwnedDiagramElements().size());
        Assert.assertEquals((long)(containementFeatureSizeBefore + 1), (long)((List)diagramRepresentation.getTarget().eGet(targetContainmentFeature)).size());
        return this.computeCreatedElement(initialDiagramElements, (EList<DDiagramElement>)diagramRepresentation.getOwnedDiagramElements());
    }

    private DDiagramElement computeCreatedElement(List<DDiagramElement> initialDiagramElements, EList<DDiagramElement> ownedDiagramElements) {
        ArrayList<DDiagramElement> currentDiagramElements = new ArrayList<DDiagramElement>((Collection<DDiagramElement>)ownedDiagramElements);
        currentDiagramElements.removeAll(initialDiagramElements);
        Assert.assertEquals((long)1L, (long)currentDiagramElements.size());
        return (DDiagramElement)currentDiagramElements.get(0);
    }

    protected boolean isBorderNode(String elementToDropMappingType) {
        return false;
    }
}

