/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.markerlistener.dialogs;

import java.lang.reflect.InvocationTargetException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.papyrus.infra.services.markerlistener.Activator;
import org.eclipse.papyrus.infra.services.markerlistener.internal.messages.Messages;
import org.eclipse.papyrus.infra.services.markerlistener.providers.IMarkerProvider;
import org.eclipse.papyrus.infra.services.markerlistener.util.MarkerListenerUtils;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class DiagnosticDialog
extends ErrorDialog {
    public static final int CREATE_MARKERS_ID = 1025;
    private final Diagnostic diagnostics;

    public DiagnosticDialog(Shell parentShell, String dialogTitle, String message, Diagnostic diagnostics, int displayMask) {
        super(parentShell, dialogTitle, message, BasicDiagnostic.toIStatus((Diagnostic)diagnostics), displayMask);
        this.diagnostics = diagnostics;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.createButton(parent, 1025, Messages.DiagnosticDialog_0, false);
    }

    protected void buttonPressed(int id) {
        switch (id) {
            case 1025: {
                this.createMarkers();
                this.getButton(1025).setEnabled(false);
                break;
            }
            default: {
                super.buttonPressed(id);
            }
        }
    }

    protected void createMarkers() {
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    Map<Resource, Diagnostic> partitions = DiagnosticDialog.this.partitionByResource(DiagnosticDialog.this.diagnostics);
                    SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)partitions.size());
                    for (Map.Entry<Resource, Diagnostic> next : partitions.entrySet()) {
                        IMarkerProvider provider = DiagnosticDialog.this.getMarkerProvider(next.getKey());
                        if (provider == null) {
                            subMonitor.worked(1);
                            continue;
                        }
                        try {
                            provider.createMarkers(next.getKey(), next.getValue(), (IProgressMonitor)subMonitor.newChild(1));
                        }
                        catch (CoreException e) {
                            Activator.log.error("Error creating problem markers.", (Throwable)e);
                        }
                    }
                    subMonitor.done();
                }
            });
        }
        catch (Exception e) {
            Activator.log.error((Throwable)e);
        }
    }

    protected Map<Resource, Diagnostic> partitionByResource(Diagnostic diagnostics) {
        LinkedHashMap<Resource, Diagnostic> result = new LinkedHashMap<Resource, Diagnostic>();
        if (!diagnostics.getChildren().isEmpty()) {
            for (Diagnostic next : diagnostics.getChildren()) {
                Resource context = this.getContextResource(next);
                if (context == null) continue;
                DiagnosticChain chain = (DiagnosticChain)result.get(context);
                if (chain == null) {
                    chain = new BasicDiagnostic();
                    result.put(context, (Diagnostic)chain);
                }
                chain.add(next);
            }
        }
        return result;
    }

    protected Resource getContextResource(Diagnostic diagnostic) {
        Resource result = null;
        List data = diagnostic.getData();
        if (data != null && !data.isEmpty()) {
            for (Object next : data) {
                if (next instanceof Resource) {
                    result = (Resource)next;
                    break;
                }
                if (next instanceof EObject && (result = ((EObject)next).eResource()) != null) break;
            }
        }
        return result;
    }

    protected IMarkerProvider getMarkerProvider(Resource context) {
        List<IMarkerProvider> providers = MarkerListenerUtils.getMarkerProviders(context);
        return providers == null || providers.isEmpty() ? null : providers.get(0);
    }
}

