/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.common.helper;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.papyrus.infra.emf.gmf.util.GMFUnsafe;
import org.eclipse.papyrus.infra.nattable.common.Activator;
import org.eclipse.papyrus.infra.nattable.common.reconciler.TableReconciler;
import org.eclipse.papyrus.infra.nattable.common.reconciler.TableReconcilersReader;
import org.eclipse.papyrus.infra.nattable.common.reconciler.TableVersioningUtils;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;

public class TableReconcileHelper {
    private final TransactionalEditingDomain domain;

    public TableReconcileHelper(TransactionalEditingDomain domain) {
        this.domain = domain;
    }

    public void reconcileTable(Table table) throws CoreException {
        CompositeCommand migration = this.buildReconcileCommand(table);
        if (migration == null) {
            return;
        }
        migration.add((IUndoableOperation)TableVersioningUtils.createStampCurrentVersionCommand(table));
        try {
            GMFUnsafe.write((TransactionalEditingDomain)this.domain, (ICommand)migration);
        }
        catch (ExecutionException e) {
            this.handleReconcileException(table, (Exception)((Object)e));
        }
        catch (InterruptedException e) {
            this.handleReconcileException(table, e);
        }
        catch (RollbackException e) {
            this.handleReconcileException(table, (Exception)((Object)e));
        }
    }

    protected CompositeCommand buildReconcileCommand(Table table) {
        CompositeCommand reconcileCommand = new CompositeCommand("Reconciling");
        if (!TableVersioningUtils.isOfCurrentPapyrusVersion(table)) {
            String sourceVersion = TableVersioningUtils.getCompatibilityVersion(table);
            List<TableReconciler> reconcilers = TableReconcilersReader.getInstance().load();
            boolean someFailed = false;
            Iterator<TableReconciler> reconciler = reconcilers.iterator();
            while (reconciler.hasNext() && !someFailed) {
                ICommand nextCommand;
                TableReconciler next = reconciler.next();
                if (!next.canReconcileFrom(table, sourceVersion) || (nextCommand = next.getReconcileCommand(table)) == null) continue;
                if (nextCommand.canExecute()) {
                    reconcileCommand.add((IUndoableOperation)nextCommand);
                    continue;
                }
                Activator.log.error("Table reconciler " + String.valueOf(next) + " failed to reconcile table : " + String.valueOf(table), null);
                someFailed = true;
            }
            if (someFailed) {
                reconcileCommand = null;
            }
        }
        return reconcileCommand;
    }

    protected void handleReconcileException(Table table, Exception e) throws CoreException {
        Activator.log.error("Reconciling the table: " + String.valueOf(table), (Throwable)e);
    }
}

