/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.resize.command;

import java.util.List;
import org.eclipse.nebula.widgets.nattable.command.AbstractLayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionUtil;
import org.eclipse.nebula.widgets.nattable.coordinate.Range;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.resize.command.MultiRowResizeCommand;
import org.eclipse.nebula.widgets.nattable.resize.event.RowResizeEvent;

public class MultiRowResizeCommandHandler
extends AbstractLayerCommandHandler<MultiRowResizeCommand> {
    private final DataLayer dataLayer;

    public MultiRowResizeCommandHandler(DataLayer dataLayer) {
        this.dataLayer = dataLayer;
    }

    @Override
    public Class<MultiRowResizeCommand> getCommandClass() {
        return MultiRowResizeCommand.class;
    }

    @Override
    protected boolean doCommand(MultiRowResizeCommand command) {
        int[] rowPositions;
        int[] nArray = rowPositions = command.getRowPositionsArray();
        int n = rowPositions.length;
        int n2 = 0;
        while (n2 < n) {
            int rowPosition = nArray[n2];
            int newRowHeight = command.downScaleValue() ? this.dataLayer.downScaleRowHeight(command.getRowHeight(rowPosition)) : command.getRowHeight(rowPosition);
            this.dataLayer.setRowHeightByPosition(rowPosition, newRowHeight, false);
            ++n2;
        }
        List<Range> ranges = PositionUtil.getRanges(rowPositions);
        for (Range range : ranges) {
            this.dataLayer.fireLayerEvent(new RowResizeEvent((ILayer)this.dataLayer, range));
        }
        return true;
    }
}

