/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.emf.facet.custom.core.internal.query;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrus.emf.facet.custom.metamodel.v0_2_0.custom.ETypedElementCase;
import org.eclipse.papyrus.emf.facet.custom.metamodel.v0_2_0.custom.ETypedElementSwitchQuery;
import org.eclipse.papyrus.emf.facet.efacet.core.IDerivedTypedElementManager;
import org.eclipse.papyrus.emf.facet.efacet.core.IFacetManager;
import org.eclipse.papyrus.emf.facet.efacet.core.exception.DerivedTypedElementException;
import org.eclipse.papyrus.emf.facet.efacet.core.query.IQueryImplementation;
import org.eclipse.papyrus.emf.facet.efacet.metamodel.v0_2_0.efacet.DerivedTypedElement;
import org.eclipse.papyrus.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetOperation;
import org.eclipse.papyrus.emf.facet.efacet.metamodel.v0_2_0.efacet.ParameterValue;
import org.eclipse.papyrus.emf.facet.efacet.metamodel.v0_2_0.efacet.extensible.Query;

public class SwitchQueryImplementation
implements IQueryImplementation {
    private static final String PARAM_NAME = "eStructuralFeature";
    private final ETypedElementSwitchQuery query;
    private boolean checkResultType = false;

    public SwitchQueryImplementation(ETypedElementSwitchQuery query) {
        this.query = query;
    }

    public Object getValue(Query query2, DerivedTypedElement feature, EObject source, List<ParameterValue> parameterValues, IFacetManager facetManager) throws DerivedTypedElementException {
        EStructuralFeature sfParam = null;
        Query subQuery = null;
        for (ParameterValue parameterValue : parameterValues) {
            if (!parameterValue.getParameter().getName().equals(PARAM_NAME)) continue;
            sfParam = (EStructuralFeature)parameterValue.getValue();
        }
        for (ETypedElementCase eTECase : this.query.getCases()) {
            if (eTECase.getCase() == sfParam && (subQuery = eTECase.getValue()) != null) break;
        }
        if (subQuery == null) {
            if (feature instanceof FacetOperation) {
                FacetOperation operation = (FacetOperation)feature;
                DerivedTypedElement superOperation = operation.getOverride();
                if (superOperation == null) {
                    return null;
                }
                if (superOperation instanceof FacetOperation) {
                    FacetOperation superFacetOperation = (FacetOperation)superOperation;
                    subQuery = superFacetOperation.getQuery();
                } else {
                    throw new UnsupportedOperationException("Overridden typed element is not a FacetOperation");
                }
            }
            if (subQuery == null) {
                return null;
            }
        }
        return IDerivedTypedElementManager.INSTANCE.evaluate(subQuery, source, parameterValues, facetManager);
    }

    public void setValue(Query query2, DerivedTypedElement feature, EObject source, List<ParameterValue> parameterValues, Object newValue) throws DerivedTypedElementException {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public boolean isCheckResultType() {
        return this.checkResultType;
    }

    public void setCheckResultType(boolean checkResultType) {
        this.checkResultType = checkResultType;
    }
}

