/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.sasheditor.internal;

import org.eclipse.papyrus.infra.core.sasheditor.editor.IPageImageUtils;
import org.eclipse.papyrus.infra.core.sasheditor.internal.PagePart;
import org.eclipse.papyrus.infra.core.sasheditor.internal.preferences.ITabTooltipPreferences;
import org.eclipse.papyrus.infra.core.sasheditor.internal.preferences.TabTooltipPreferences;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ImageToolTipManager {
    protected ITabTooltipPreferences settings = new TabTooltipPreferences();
    private Control toolTipedControl;
    private Rectangle toolTipExpectedSize = new Rectangle(0, 0, 100, 80);
    private int offsetX = 20;
    private int offsetY = 20;
    private int toolTipAlignement = 128;
    private Shell tip = null;
    private Image image = null;

    private void resetTimer() {
        if (this.settings.getTooltipAutoCloseDelay() == -1) {
            return;
        }
    }

    public void closeToolTip() {
        if (this.tip != null) {
            this.tip.dispose();
            this.tip = null;
        }
        if (this.image != null) {
            this.image.dispose();
            this.image = null;
        }
        this.toolTipedControl = null;
    }

    public void disableToolTip() {
        if (this.tip != null) {
            this.tip.dispose();
            this.tip = null;
        }
        if (this.image != null) {
            this.image.dispose();
            this.image = null;
        }
    }

    public void dispose() {
        if (this.tip != null) {
            this.tip.dispose();
            this.tip = null;
        }
        if (this.image != null) {
            this.image.dispose();
            this.image = null;
        }
        this.toolTipedControl = null;
    }

    public void showToolTip(PagePart pagePart, Rectangle flyedControlBounds, Point mousePos) {
        if (this.toolTipedControl == pagePart.getControl()) {
            this.resetTimer();
            return;
        }
        if (!this.settings.isTooltipEnable()) {
            return;
        }
        if (!this.settings.isTooltipForCurrentTabShown() && pagePart.getParent().getVisiblePagePart() == pagePart) {
            this.closeToolTip();
            return;
        }
        this.doShowToolTip(pagePart, flyedControlBounds, mousePos);
    }

    private void doShowToolTip(PagePart pagePart, Rectangle flyedControlBounds, Point mousePos) {
        Image image = this.getPageImage(pagePart);
        if (image == null) {
            return;
        }
        this.toolTipedControl = pagePart.getControl();
        float scaleFactor = this.settings.getScaledFactor();
        Image scaledImage = this.scaledImage((Device)pagePart.getControl().getDisplay(), image, scaleFactor);
        image.dispose();
        this.image = scaledImage;
        Point pos = this.computeToolTipPosition(flyedControlBounds, mousePos, scaledImage.getBounds());
        this.openToolTip(pagePart.getControl(), scaledImage, pos);
    }

    private Point computeToolTipPosition(Rectangle relatedControlBounds, Point mousePos, Rectangle toolTipSize) {
        int y;
        int x;
        if (this.toolTipAlignement == 128) {
            x = mousePos.x;
            y = relatedControlBounds.y - (toolTipSize.height + this.offsetY);
        } else if (this.toolTipAlignement == 1024) {
            x = mousePos.x;
            y = relatedControlBounds.y + (relatedControlBounds.height + this.offsetY);
        } else {
            throw new UnsupportedOperationException("Not yet implemented for this alignement.");
        }
        return new Point(x, y);
    }

    private void openToolTip(Control device, Image scaledImage, Point atPoint) {
        if (this.tip != null && !this.tip.isDisposed()) {
            this.tip.dispose();
        }
        this.tip = new Shell(device.getShell(), 540676);
        FillLayout layout = new FillLayout();
        layout.marginWidth = 2;
        this.tip.setLayout((Layout)layout);
        Label label = new Label((Composite)this.tip, 0);
        label.setImage(scaledImage);
        Point size = this.tip.computeSize(-1, -1);
        Point pt = device.toDisplay(atPoint.x + 20, atPoint.y);
        this.tip.setBounds(pt.x, pt.y, size.x, size.y);
        this.tip.setVisible(true);
    }

    private Image createControlImage(Control control) {
        Rectangle size = control.getBounds();
        if (size.width == 0 && size.height == 0) {
            Point pt = control.computeSize(-1, -1);
            size = new Rectangle(0, 0, pt.x, pt.y);
        }
        Image image = new Image((Device)control.getDisplay(), size);
        GC gc = new GC((Drawable)image);
        boolean success = control.print(gc);
        gc.dispose();
        if (!success) {
            image.dispose();
            return null;
        }
        return image;
    }

    private Image scaledImage2(Device device, Image image, float factor) {
        Rectangle imageBounds = image.getBounds();
        Rectangle size = this.computeToolTipSize(image, factor);
        Image scaledImage = new Image(device, size);
        GC gc = new GC((Drawable)scaledImage);
        gc.drawImage(image, 0, 0, imageBounds.width, imageBounds.height, 0, 0, size.width, size.height);
        return scaledImage;
    }

    private Rectangle computeToolTipSize(Image image, float factor) {
        return this.toolTipExpectedSize;
    }

    private Image scaledImage(Device device, Image image, float factor) {
        Rectangle bounds = image.getBounds();
        Rectangle newBounds = new Rectangle(0, 0, Math.round((float)bounds.width * factor), Math.round((float)bounds.height * factor));
        Image scaledImage = new Image(device, newBounds);
        GC gc = new GC((Drawable)scaledImage);
        gc.setAdvanced(true);
        gc.setAntialias(1);
        Transform tr = new Transform(device);
        tr.scale(factor, factor);
        gc.setTransform(tr);
        gc.drawImage(image, 0, 0);
        gc.dispose();
        tr.dispose();
        return scaledImage;
    }

    private Image getPageImage(PagePart pagePart) {
        return IPageImageUtils.getPageImage(pagePart);
    }
}

