/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.uml.diagram.common.core.services;

import org.eclipse.papyrus.uml.internationalization.utils.utils.UMLLabelInternationalization;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.ElementImport;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.util.UMLSwitch;

public class UMLInternationalizedNameSwitch
extends UMLSwitch<String> {
    private boolean useQualifiedName = false;

    public void useQualifiedName(boolean useQualifiedName) {
        this.useQualifiedName = useQualifiedName;
    }

    public String caseNamedElement(NamedElement namedElement) {
        if (this.useQualifiedName) {
            return UMLLabelInternationalization.getInstance().getQualifiedLabel(namedElement);
        }
        return UMLLabelInternationalization.getInstance().getLabel(namedElement);
    }

    public String caseComment(Comment comment) {
        return comment.getBody();
    }

    public String caseElementImport(ElementImport elementImport) {
        return elementImport.getAlias();
    }

    public String caseMultiplicityElement(MultiplicityElement multiplicityElement) {
        int lower = multiplicityElement.getLower();
        int upper = multiplicityElement.getUpper();
        StringBuffer label = new StringBuffer();
        label.append("[");
        if (lower == upper) {
            label.append(lower);
        } else if (lower == 0 && upper == -1) {
            label.append("*");
        } else {
            label.append(lower);
            label.append(".").append(".");
            if (upper == -1) {
                label.append("*");
            } else {
                label.append(upper);
            }
        }
        label.append("]");
        return label.toString();
    }
}

