/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.modelexplorer.preferences;

import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.papyrus.infra.ui.preferences.AbstractPreferenceGroup;
import org.eclipse.papyrus.views.modelexplorer.Activator;
import org.eclipse.papyrus.views.modelexplorer.Messages;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class FilterFieldPreferencesGroup
extends AbstractPreferenceGroup {
    private IPropertyChangeListener listener = event -> this.refreshDelayField(event);
    private IntegerFieldEditor delayFieldEditor;
    private Group fieldGroup;
    private FieldEditor liveValidationfieldEditor;
    private BooleanFieldEditor stereotypeDelimiterfieldEditor;

    public FilterFieldPreferencesGroup(Composite parent, String title, DialogPage dialogPage) {
        super(parent, title, dialogPage);
        this.createContent(parent);
    }

    public void createContent(Composite parent) {
        this.fieldGroup = new Group(parent, 2);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        this.fieldGroup.setLayout((Layout)layout);
        this.fieldGroup.setText(Messages.FilterFieldPreferencesGroup_groupTitle);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fieldGroup);
        this.liveValidationfieldEditor = new BooleanFieldEditor("liveValidation", Messages.FilterFieldPreferencesGroup_UseValidationPreferenceLabel, (Composite)this.fieldGroup);
        this.liveValidationfieldEditor.setPage(this.dialogPage);
        this.addFieldEditor(this.liveValidationfieldEditor);
        Composite composite = new Composite((Composite)this.fieldGroup, 0);
        GridDataFactory.fillDefaults().hint(5, 5).applyTo((Control)composite);
        this.liveValidationfieldEditor.setPropertyChangeListener(this.listener);
        this.delayFieldEditor = new IntegerFieldEditor("validateDelay", Messages.FilterFieldPreferencesGroup_ValidationDelayPreferenceLabel, (Composite)this.fieldGroup);
        this.delayFieldEditor.setPage(this.dialogPage);
        this.addFieldEditor((FieldEditor)this.delayFieldEditor);
        this.delayFieldEditor.setEnabled(Activator.getDefault().getPreferenceStore().getBoolean("liveValidation"), (Composite)this.fieldGroup);
        this.stereotypeDelimiterfieldEditor = new BooleanFieldEditor("replaceStrereotypeDelimiter", Messages.FilterFieldPreferencesGroup_replaceDelimiterLabel, (Composite)this.fieldGroup);
        this.stereotypeDelimiterfieldEditor.setPage(this.dialogPage);
        this.addFieldEditor((FieldEditor)this.stereotypeDelimiterfieldEditor);
    }

    private void refreshDelayField(PropertyChangeEvent event) {
        if (this.delayFieldEditor != null && this.liveValidationfieldEditor != null && event.getSource().equals(this.liveValidationfieldEditor)) {
            this.delayFieldEditor.setEnabled(((Boolean)event.getNewValue()).booleanValue(), (Composite)this.fieldGroup);
        }
    }

    public void dispose() {
        this.liveValidationfieldEditor.setPropertyChangeListener(null);
        super.dispose();
    }
}

