/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.decoratormodel.internal.ui.commands;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.uml.decoratormodel.helper.DecoratorModelUtils;
import org.eclipse.papyrus.uml.decoratormodel.internal.ui.messages.Messages;
import org.eclipse.papyrus.uml.decoratormodel.internal.ui.wizards.UnloadProfileApplicationsWizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.uml2.uml.Package;

public class UnloadLoadedDecoratorModelsHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event).getWorkbench().getActiveWorkbenchWindow();
        ISelection selection = HandlerUtil.getActiveMenuSelectionChecked((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            Package package_ = (Package)EMFHelper.getEObject((Object)((IStructuredSelection)selection).getFirstElement());
            HashSet loaded = Sets.newHashSet();
            loaded.addAll(DecoratorModelUtils.getLoadedDecoratorModels((Resource)package_.eResource()));
            for (Package subUnit : DecoratorModelUtils.getLoadedSubUnitPackages((Package)package_)) {
                loaded.addAll(DecoratorModelUtils.getLoadedDecoratorModels((Resource)subUnit.eResource()));
            }
            if (loaded.isEmpty()) {
                MessageDialog.openWarning((Shell)window.getShell(), (String)Messages.UnloadLoadedDecoratorModelsHandler_0, (String)Messages.UnloadLoadedDecoratorModelsHandler_1);
            } else {
                UnloadProfileApplicationsWizard wizard = new UnloadProfileApplicationsWizard();
                wizard.init(package_, (Iterable)Collections.emptySet());
                WizardDialog dlg = new WizardDialog(window.getShell(), (IWizard)wizard);
                dlg.open();
            }
        }
        return null;
    }
}

