/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.properties.profile.ui.compositesformodel;

import java.util.ArrayList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.uml.internationalization.utils.utils.UMLLabelInternationalization;
import org.eclipse.papyrus.uml.profile.Message;
import org.eclipse.papyrus.uml.profile.tree.ProfileElementContentProvider;
import org.eclipse.papyrus.uml.profile.tree.ProfileElementLabelProvider;
import org.eclipse.papyrus.uml.profile.tree.objects.AppliedStereotypePropertyTreeObject;
import org.eclipse.papyrus.uml.profile.tree.objects.AppliedStereotypeTreeObject;
import org.eclipse.papyrus.uml.profile.tree.objects.StereotypedElementTreeObject;
import org.eclipse.papyrus.uml.profile.tree.objects.ValueTreeObject;
import org.eclipse.papyrus.uml.properties.Activator;
import org.eclipse.papyrus.uml.properties.profile.ui.compositesformodel.DecoratedTreeComposite;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;

public class PropertyComposite
extends DecoratedTreeComposite {
    public TransactionalEditingDomain getEditingDomain(EModelElement context) {
        try {
            return ServiceUtilsForEObject.getInstance().getTransactionalEditingDomain((Object)context);
        }
        catch (ServiceException ex) {
            Activator.log.error((Throwable)ex);
            return null;
        }
    }

    public PropertyComposite(Composite parent) {
        super(parent, 0, "Property values", false);
    }

    @Override
    public Composite createContent(Composite parent, TabbedPropertySheetWidgetFactory factory) {
        super.createContent(parent, factory);
        this.createPropTree();
        return this;
    }

    protected void createPropTree() {
        this.treeViewer.setContentProvider((IContentProvider)new ProfileElementContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new ProfileElementLabelProvider());
    }

    @Override
    public void refresh() {
        if (this.treeViewer.getTree() != null && !this.treeViewer.getTree().isDisposed()) {
            this.treeViewer.refresh();
            AppliedStereotypePropertyTreeObject pTO = (AppliedStereotypePropertyTreeObject)this.treeViewer.getInput();
            if (pTO == null) {
                this.setVisible(false);
            } else if (pTO.getProperty() != null && pTO.getProperty().isReadOnly()) {
                this.upButton.setEnabled(false);
                this.downButton.setEnabled(false);
                this.removeButton.setEnabled(false);
                this.addButton.setEnabled(false);
            } else {
                this.upButton.setEnabled(true);
                this.downButton.setEnabled(true);
                this.removeButton.setEnabled(true);
                this.addButton.setEnabled(true);
                if (pTO.getChildren() != null && pTO.getChildren().length > 1) {
                    this.upButton.setEnabled(true);
                    this.downButton.setEnabled(true);
                } else {
                    this.upButton.setEnabled(false);
                    this.downButton.setEnabled(false);
                }
                if (pTO.getChildren() != null && pTO.getChildren().length == pTO.getProperty().getLower()) {
                    this.removeButton.setEnabled(false);
                } else {
                    this.removeButton.setEnabled(true);
                }
                if (pTO.getChildren() != null && pTO.getChildren().length == pTO.getProperty().getUpper()) {
                    this.addButton.setEnabled(false);
                } else {
                    this.addButton.setEnabled(true);
                }
                this.setVisible(true);
            }
        }
    }

    public void itemDClicked() {
        AppliedStereotypePropertyTreeObject pTO = (AppliedStereotypePropertyTreeObject)this.treeViewer.getInput();
        pTO.reInitChilds();
    }

    @Override
    public void addButtonPressed() {
        int upper;
        AppliedStereotypePropertyTreeObject pTO = (AppliedStereotypePropertyTreeObject)this.treeViewer.getInput();
        Property property = pTO.getProperty();
        Stereotype selectedSt = ((AppliedStereotypeTreeObject)pTO.getParent()).getStereotype();
        Element selectedElt = ((StereotypedElementTreeObject)pTO.getParent().getParent()).getElement();
        if (property == null || selectedSt == null || selectedElt == null) {
            return;
        }
        int lower = property.getLower();
        if (lower == (upper = property.getUpper()) && pTO.getValue() != null) {
            if (pTO.getValue() instanceof EList) {
                EList currentValues = (EList)pTO.getValue();
                if (currentValues.size() >= upper) {
                    Message.warning((String)("Multiplicity of this property is " + property.getLower() + ".." + property.getUpper() + "\nImpossible to add a new value."));
                    return;
                }
            } else {
                Message.warning((String)("Multiplicity of this property is " + property.getLower() + ".." + property.getUpper() + "\nImpossible to add a new value."));
                return;
            }
        }
        ArrayList<Object> currentPropertyValues = new ArrayList<Object>();
        Object currentValue = pTO.getValue();
        if (currentValue != null) {
            if (upper == 1) {
                currentPropertyValues.add(currentValue);
            } else {
                EList currentValues = (EList)currentValue;
                int i = 0;
                while (i < currentValues.size()) {
                    currentPropertyValues.add(currentValues.get(i));
                    ++i;
                }
            }
        }
        if (property.isMultivalued() || currentPropertyValues.size() < upper) {
            ValueTreeObject.createInstance((AppliedStereotypePropertyTreeObject)pTO, null).editMe();
        } else {
            Message.warning((String)("Upper multiplicity of " + UMLLabelInternationalization.getInstance().getLabel((NamedElement)property) + " is " + property.getUpper()));
        }
        pTO.reInitChilds();
    }

    @Override
    public void removeButtonPressed() {
        int nbrOfSelection = this.getTree().getSelectionCount();
        if (nbrOfSelection == 0) {
            return;
        }
        TreeItem[] items = this.getTree().getSelection();
        int i = 0;
        while (i < nbrOfSelection) {
            int upper;
            ValueTreeObject vTO = (ValueTreeObject)items[i].getData();
            AppliedStereotypePropertyTreeObject pTO = (AppliedStereotypePropertyTreeObject)this.treeViewer.getInput();
            Property property = pTO.getProperty();
            int lower = property.getLower();
            if (lower == (upper = property.getUpper())) {
                Message.warning((String)("Multiplicity of this property is" + lower + ".." + upper + "\nImpossible to remove a value."));
                return;
            }
            Object currentVal = pTO.getValue();
            ArrayList tempValues = new ArrayList();
            if (upper != 1) {
                EList currentValues = (EList)currentVal;
                tempValues.addAll(currentValues);
                if (tempValues.size() > lower) {
                    tempValues.remove(vTO.getValue());
                }
            }
            if (property.isMultivalued()) {
                pTO.updateValue(tempValues);
            } else {
                pTO.updateValue(null);
            }
            pTO.reInitChilds();
            ++i;
        }
    }

    @Override
    public void upButtonPressed() {
        int nbrOfSelection = this.getTree().getSelectionCount();
        if (nbrOfSelection < 1) {
            return;
        }
        TreeItem[] items = this.getTree().getSelection();
        int indexFirst = this.getTree().indexOf(items[0]);
        if (indexFirst == 0) {
            return;
        }
        int i = 0;
        while (i < nbrOfSelection) {
            ValueTreeObject vTO = (ValueTreeObject)items[i].getData();
            int index = this.getTree().indexOf(items[i]);
            vTO.moveMeUp(index);
            ++i;
        }
    }

    @Override
    public void downButtonPressed() {
        int nbrOfSelection = this.getTree().getSelectionCount();
        if (nbrOfSelection < 1) {
            return;
        }
        TreeItem[] items = this.getTree().getSelection();
        AppliedStereotypePropertyTreeObject pTO = (AppliedStereotypePropertyTreeObject)this.treeViewer.getInput();
        int indexLastValue = -1;
        if (pTO.getChildren() != null) {
            indexLastValue = pTO.getChildren().length - 1;
        }
        int indexLastSelection = this.getTree().indexOf(items[nbrOfSelection - 1]);
        if (indexLastValue == -1 || indexLastSelection == indexLastValue) {
            return;
        }
        int i = 0;
        while (i < nbrOfSelection) {
            ValueTreeObject vTO = (ValueTreeObject)items[nbrOfSelection - 1 - i].getData();
            int index = this.getTree().indexOf(items[nbrOfSelection - 1 - i]);
            vTO.moveMeDown(index);
            ++i;
        }
    }

    public void setInput(AppliedStereotypePropertyTreeObject element) {
        this.treeViewer.setInput((Object)element);
        if (element != null) {
            element.reInitChilds();
        }
        this.refresh();
    }

    public Tree getTree() {
        return this.treeViewer.getTree();
    }

    @Override
    public void editItem(TreeItem item) {
    }
}

