/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.onefile.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.papyrus.infra.onefile.Activator;
import org.eclipse.papyrus.infra.onefile.model.IDiViewFilter;
import org.osgi.framework.Bundle;

public class DiViewFilterHelper {
    private static DiViewFilterHelper instance;
    private static final String DI_VIEW_FILTER = "diViewFilter";
    public static List<Segment> segments;

    private DiViewFilterHelper() {
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.papyrus.infra.onefile", DI_VIEW_FILTER);
        segments = new ArrayList<Segment>(elements.length);
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            Segment s = new Segment();
            try {
                s.priority = Integer.parseInt(e.getAttribute("priority"));
                s.bundle = Platform.getBundle((String)e.getContributor().getName());
                s.className = e.getAttribute("instance");
                segments.add(s);
            }
            catch (NumberFormatException ex) {
                Activator.log.error((Throwable)ex);
            }
            ++n2;
        }
        Collections.sort(segments, new Comparator<Segment>(){

            @Override
            public int compare(Segment o1, Segment o2) {
                Integer val1 = o1 != null ? o1.priority : 0;
                Integer val2 = o2 != null ? o2.priority : 0;
                return val1.compareTo(val2);
            }
        });
    }

    public static DiViewFilterHelper getInstance() {
        if (instance == null) {
            instance = new DiViewFilterHelper();
        }
        return instance;
    }

    public IDiViewFilter getPapyrusDiViewFilter() {
        if (segments == null || segments.size() == 0) {
            throw new RuntimeException("Initialisation error, please register extension to org.eclipse.papyrus.infra.onefile.diViewFilter");
        }
        return segments.get(segments.size() - 1).getDiViewFilter();
    }

    private static class Segment {
        public String className;
        public Bundle bundle;
        public int priority;
        public IDiViewFilter instance = null;

        private Segment() {
        }

        public IDiViewFilter getDiViewFilter() {
            if (this.instance == null) {
                try {
                    this.instance = (IDiViewFilter)this.bundle.loadClass(this.className).newInstance();
                }
                catch (InstantiationException e) {
                    Activator.log.error((Throwable)e);
                }
                catch (IllegalAccessException e) {
                    Activator.log.error((Throwable)e);
                }
                catch (ClassNotFoundException e) {
                    Activator.log.error((Throwable)e);
                }
            }
            return this.instance;
        }
    }
}

