/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.manager.cell;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.nattable.manager.cell.ICellManager;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.utils.AxisUtils;
import org.eclipse.papyrus.infra.ui.converter.AbstractStringValueConverter;

public class ActionCellManager
implements ICellManager {
    protected List<Object> organizeAndResolvedObjects(Object columnElement, Object rowElement, Map<?, ?> sharedMap) {
        ArrayList<Object> objects = null;
        Object row = AxisUtils.getRepresentedElement(rowElement);
        Object column = AxisUtils.getRepresentedElement(columnElement);
        if (row instanceof EObject && column instanceof String) {
            objects = new ArrayList<Object>();
            objects.add(row);
            objects.add(column);
        } else if (column instanceof EObject && row instanceof String) {
            objects = new ArrayList();
            objects.add(column);
            objects.add(row);
        }
        return objects;
    }

    @Override
    public boolean handles(Object columnElement, Object rowElement, INattableModelManager tableManager) {
        List<Object> objects = this.organizeAndResolvedObjects(columnElement, rowElement, null);
        if (objects != null && objects.size() == 2) {
            String string = (String)objects.get(1);
            return string.startsWith("action:/");
        }
        return false;
    }

    @Override
    public Object getValue(Object columnElement, Object rowElement, INattableModelManager tableManager) {
        List<Object> objects = this.organizeAndResolvedObjects(columnElement, rowElement, null);
        if (objects.size() == 2) {
            Object object = objects.get(0);
            if (EMFHelper.isReadOnly((EObject)((EObject)object))) {
                return "";
            }
            String string = (String)objects.get(1);
            return string.replace("action:/", "");
        }
        return "";
    }

    @Override
    public void setValue(TransactionalEditingDomain domain, Object columnElement, Object rowElement, Object newValue, INattableModelManager tableManager) {
    }

    @Override
    public boolean isCellEditable(Object columnElement, Object rowElement, INattableModelManager tableManager) {
        return false;
    }

    @Override
    public Command getSetValueCommand(TransactionalEditingDomain domain, Object columnElement, Object rowElement, Object newValue, INattableModelManager tableManager) {
        return null;
    }

    @Override
    public Command getSetStringValueCommand(TransactionalEditingDomain domain, Object columnElement, Object rowElement, String newValue, AbstractStringValueConverter valueConverter, INattableModelManager tableManager) {
        return null;
    }

    @Override
    public AbstractStringValueConverter getOrCreateStringValueConverterClass(Map<Class<? extends AbstractStringValueConverter>, AbstractStringValueConverter> existingConverters, String multiValueSeparator, INattableModelManager tableManager) {
        return null;
    }

    @Override
    public boolean isCellEditable(Object columnElement, Object rowElement, Map<?, ?> sharedMap, INattableModelManager tableManager) {
        return false;
    }

    @Override
    public void setStringValue(Object columnElement, Object rowElement, String valueAsString, AbstractStringValueConverter valueConverter, Map<?, ?> sharedMap, INattableModelManager tableManager) {
    }

    @Override
    public String getUnsupportedCellContentsText() {
        return null;
    }
}

