/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.providers;

import java.util.ArrayList;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.service.AbstractProvider;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.providers.IViewProvider;
import org.eclipse.gmf.runtime.diagram.core.services.view.CreateChildViewOperation;
import org.eclipse.gmf.runtime.diagram.core.services.view.CreateDiagramViewOperation;
import org.eclipse.gmf.runtime.diagram.core.services.view.CreateEdgeViewOperation;
import org.eclipse.gmf.runtime.diagram.core.services.view.CreateNodeViewOperation;
import org.eclipse.gmf.runtime.diagram.core.services.view.CreateViewForKindOperation;
import org.eclipse.gmf.runtime.diagram.core.services.view.CreateViewOperation;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.notation.BasicCompartment;
import org.eclipse.gmf.runtime.notation.Bendpoints;
import org.eclipse.gmf.runtime.notation.Connector;
import org.eclipse.gmf.runtime.notation.DecorationNode;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.MeasurementUnit;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.RelativeBendpoints;
import org.eclipse.gmf.runtime.notation.Shape;
import org.eclipse.gmf.runtime.notation.TitleStyle;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.runtime.notation.datatype.RelativeBendpoint;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.papyrus.infra.gmfdiag.common.reconciler.DiagramVersioningUtils;
import org.eclipse.papyrus.uml.diagram.common.helper.PreferenceInitializerForElementHelper;
import org.eclipse.papyrus.uml.diagram.sequence.part.UMLVisualIDRegistry;
import org.eclipse.papyrus.uml.diagram.sequence.providers.UMLElementTypes;

public class UMLViewProvider
extends AbstractProvider
implements IViewProvider {
    public final boolean provides(IOperation operation) {
        if (operation instanceof CreateViewForKindOperation) {
            return this.provides((CreateViewForKindOperation)operation);
        }
        assert (operation instanceof CreateViewOperation);
        if (operation instanceof CreateChildViewOperation) {
            View container = ((CreateChildViewOperation)operation).getContainerView();
            Diagram diagram = container.getDiagram();
            if (!this.getDiagramProvidedId().equals(diagram.getType())) {
                return false;
            }
        }
        if (operation instanceof CreateDiagramViewOperation) {
            return this.provides((CreateDiagramViewOperation)operation);
        }
        if (operation instanceof CreateEdgeViewOperation) {
            return this.provides((CreateEdgeViewOperation)operation);
        }
        if (operation instanceof CreateNodeViewOperation) {
            return this.provides((CreateNodeViewOperation)operation);
        }
        return false;
    }

    protected boolean provides(CreateViewForKindOperation op) {
        String modelID = UMLVisualIDRegistry.getModelID(op.getContainerView());
        if (!this.getDiagramProvidedId().equals(modelID)) {
            return false;
        }
        String visualID = UMLVisualIDRegistry.getVisualID(op.getSemanticHint());
        if (Node.class.isAssignableFrom(op.getViewKind())) {
            return UMLVisualIDRegistry.canCreateNode(op.getContainerView(), visualID);
        }
        return true;
    }

    protected String getDiagramProvidedId() {
        return "PapyrusUMLSequenceDiagram";
    }

    protected boolean provides(CreateDiagramViewOperation op) {
        return "PapyrusUMLSequenceDiagram".equals(op.getSemanticHint()) && UMLVisualIDRegistry.getDiagramVisualID(this.getSemanticElement(op.getSemanticAdapter())) != null && !UMLVisualIDRegistry.getDiagramVisualID(this.getSemanticElement(op.getSemanticAdapter())).isEmpty();
    }

    protected boolean provides(CreateNodeViewOperation op) {
        String visualID;
        block43: {
            EObject domainElement;
            block44: {
                IElementType elementType;
                block42: {
                    if (op.getContainerView() == null) {
                        return false;
                    }
                    elementType = this.getSemanticElementType(op.getSemanticAdapter());
                    domainElement = this.getSemanticElement(op.getSemanticAdapter());
                    if (op.getSemanticHint() != null) break block42;
                    if (elementType != null || domainElement == null) {
                        return false;
                    }
                    visualID = UMLVisualIDRegistry.getNodeVisualID(op.getContainerView(), domainElement);
                    break block43;
                }
                visualID = UMLVisualIDRegistry.getVisualID(op.getSemanticHint());
                if (elementType == null) break block44;
                if (!UMLElementTypes.isKnownElementType(elementType) || !(elementType instanceof IHintedType)) {
                    return false;
                }
                String elementTypeHint = ((IHintedType)elementType).getSemanticHint();
                if (!op.getSemanticHint().equals(elementTypeHint)) {
                    return false;
                }
                break block43;
            }
            if (!"PapyrusUMLSequenceDiagram".equals(UMLVisualIDRegistry.getModelID(op.getContainerView()))) {
                return false;
            }
            if (visualID == null) break block43;
            switch (visualID) {
                case "Gate_Shape": 
                case "Constraint_Shape": 
                case "Lifeline_Shape": 
                case "DestructionOccurrenceSpecification_Shape": 
                case "ConsiderIgnoreFragment_Shape": 
                case "StateInvariant_Shape": 
                case "ActionExecutionSpecification_Shape": 
                case "Comment_Shape": 
                case "CombinedFragment_Shape": 
                case "Continuation_Shape": 
                case "TimeObservation_Shape": 
                case "InteractionUse_Shape": 
                case "Interaction_Shape": 
                case "BehaviorExecutionSpecification_Shape": 
                case "InteractionOperand_Shape": 
                case "TimeConstraint_Shape": {
                    if (domainElement != null && visualID.equals(UMLVisualIDRegistry.getNodeVisualID(op.getContainerView(), domainElement))) break;
                    return false;
                }
                default: {
                    return false;
                }
            }
        }
        return UMLVisualIDRegistry.canCreateNode(op.getContainerView(), visualID);
    }

    protected boolean provides(CreateEdgeViewOperation op) {
        IElementType elementType = this.getSemanticElementType(op.getSemanticAdapter());
        if (!UMLElementTypes.isKnownElementType(elementType) || !(elementType instanceof IHintedType)) {
            return false;
        }
        String elementTypeHint = ((IHintedType)elementType).getSemanticHint();
        return elementTypeHint != null && (op.getSemanticHint() == null || elementTypeHint.equals(op.getSemanticHint()));
    }

    public Diagram createDiagram(IAdaptable semanticAdapter, String diagramKind, PreferencesHint preferencesHint) {
        Diagram diagram = NotationFactory.eINSTANCE.createDiagram();
        DiagramVersioningUtils.stampCurrentVersion((Diagram)diagram);
        diagram.getStyles().add((Object)NotationFactory.eINSTANCE.createDiagramStyle());
        diagram.setType("PapyrusUMLSequenceDiagram");
        diagram.setElement(this.getSemanticElement(semanticAdapter));
        diagram.setMeasurementUnit(MeasurementUnit.PIXEL_LITERAL);
        return diagram;
    }

    public Node createNode(IAdaptable semanticAdapter, View containerView, String semanticHint, int index, boolean persisted, PreferencesHint preferencesHint) {
        block52: {
            EObject domainElement = this.getSemanticElement(semanticAdapter);
            String visualID = semanticHint == null ? UMLVisualIDRegistry.getNodeVisualID(containerView, domainElement) : UMLVisualIDRegistry.getVisualID(semanticHint);
            if (visualID == null) break block52;
            switch (visualID) {
                case "Interaction_Shape": {
                    return this.createInteraction_Shape(domainElement, containerView, index, persisted, preferencesHint);
                }
                case "ConsiderIgnoreFragment_Shape": {
                    return this.createConsiderIgnoreFragment_Shape(domainElement, containerView, index, persisted, preferencesHint);
                }
                case "CombinedFragment_Shape": {
                    return this.createCombinedFragment_Shape(domainElement, containerView, index, persisted, preferencesHint);
                }
                case "InteractionOperand_Shape": {
                    return this.createInteractionOperand_Shape(domainElement, containerView, index, persisted, preferencesHint);
                }
                case "InteractionUse_Shape": {
                    return this.createInteractionUse_Shape(domainElement, containerView, index, persisted, preferencesHint);
                }
                case "Continuation_Shape": {
                    return this.createContinuation_Shape(domainElement, containerView, index, persisted, preferencesHint);
                }
                case "Lifeline_Shape": {
                    return this.createLifeline_Shape(domainElement, containerView, index, persisted, preferencesHint);
                }
                case "ActionExecutionSpecification_Shape": {
                    return this.createActionExecutionSpecification_Shape(domainElement, containerView, index, persisted, preferencesHint);
                }
                case "BehaviorExecutionSpecification_Shape": {
                    return this.createBehaviorExecutionSpecification_Shape(domainElement, containerView, index, persisted, preferencesHint);
                }
                case "StateInvariant_Shape": {
                    return this.createStateInvariant_Shape(domainElement, containerView, index, persisted, preferencesHint);
                }
                case "DestructionOccurrenceSpecification_Shape": {
                    return this.createDestructionOccurrenceSpecification_Shape(domainElement, containerView, index, persisted, preferencesHint);
                }
                case "Constraint_Shape": {
                    return this.createConstraint_Shape(domainElement, containerView, index, persisted, preferencesHint);
                }
                case "Comment_Shape": {
                    return this.createComment_Shape(domainElement, containerView, index, persisted, preferencesHint);
                }
                case "Gate_Shape": {
                    return this.createGate_Shape(domainElement, containerView, index, persisted, preferencesHint);
                }
                case "TimeConstraint_Shape": {
                    return this.createTimeConstraint_Shape(domainElement, containerView, index, persisted, preferencesHint);
                }
                case "TimeObservation_Shape": {
                    return this.createTimeObservation_Shape(domainElement, containerView, index, persisted, preferencesHint);
                }
            }
        }
        return null;
    }

    public Edge createEdge(IAdaptable semanticAdapter, View containerView, String semanticHint, int index, boolean persisted, PreferencesHint preferencesHint) {
        block43: {
            IElementType elementType = this.getSemanticElementType(semanticAdapter);
            String elementTypeHint = ((IHintedType)elementType).getSemanticHint();
            String vid = UMLVisualIDRegistry.getVisualID(elementTypeHint);
            if (vid == null) break block43;
            switch (vid) {
                case "Message_SynchEdge": {
                    return this.createMessage_SynchEdge(this.getSemanticElement(semanticAdapter), containerView, index, persisted, preferencesHint);
                }
                case "Message_AsynchEdge": {
                    return this.createMessage_AsynchEdge(this.getSemanticElement(semanticAdapter), containerView, index, persisted, preferencesHint);
                }
                case "Message_ReplyEdge": {
                    return this.createMessage_ReplyEdge(this.getSemanticElement(semanticAdapter), containerView, index, persisted, preferencesHint);
                }
                case "Message_CreateEdge": {
                    return this.createMessage_CreateEdge(this.getSemanticElement(semanticAdapter), containerView, index, persisted, preferencesHint);
                }
                case "Message_DeleteEdge": {
                    return this.createMessage_DeleteEdge(this.getSemanticElement(semanticAdapter), containerView, index, persisted, preferencesHint);
                }
                case "Message_LostEdge": {
                    return this.createMessage_LostEdge(this.getSemanticElement(semanticAdapter), containerView, index, persisted, preferencesHint);
                }
                case "Message_FoundEdge": {
                    return this.createMessage_FoundEdge(this.getSemanticElement(semanticAdapter), containerView, index, persisted, preferencesHint);
                }
                case "Comment_AnnotatedElementEdge": {
                    return this.createComment_AnnotatedElementEdge(containerView, index, persisted, preferencesHint);
                }
                case "Constraint_ConstrainedElementEdge": {
                    return this.createConstraint_ConstrainedElementEdge(containerView, index, persisted, preferencesHint);
                }
                case "GeneralOrdering_Edge": {
                    return this.createGeneralOrdering_Edge(this.getSemanticElement(semanticAdapter), containerView, index, persisted, preferencesHint);
                }
                case "Constraint_ContextEdge": {
                    return this.createConstraint_ContextEdge(containerView, index, persisted, preferencesHint);
                }
                case "DurationConstraint_Edge": {
                    return this.createDurationConstraint_Edge(this.getSemanticElement(semanticAdapter), containerView, index, persisted, preferencesHint);
                }
                case "DurationObservation_Edge": {
                    return this.createDurationObservation_Edge(this.getSemanticElement(semanticAdapter), containerView, index, persisted, preferencesHint);
                }
            }
        }
        return null;
    }

    public Node createInteraction_Shape(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType("Interaction_Shape"));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        this.stampShortcut(containerView, (Node)node);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Interaction");
        this.createLabel((View)node, UMLVisualIDRegistry.getType("Interaction_NameLabel"));
        this.createCompartment((View)node, UMLVisualIDRegistry.getType("Interaction_SubfragmentCompartment"), false, false, false, false);
        PreferenceInitializerForElementHelper.initCompartmentsStatusFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Interaction");
        return node;
    }

    public Node createConsiderIgnoreFragment_Shape(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType("ConsiderIgnoreFragment_Shape"));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"ConsiderIgnoreFragment");
        return node;
    }

    public Node createCombinedFragment_Shape(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType("CombinedFragment_Shape"));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"CombinedFragment");
        this.createCompartment((View)node, UMLVisualIDRegistry.getType("CombinedFragment_SubfragmentCompartment"), false, false, true, true);
        PreferenceInitializerForElementHelper.initCompartmentsStatusFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"CombinedFragment");
        return node;
    }

    public Node createInteractionOperand_Shape(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType("InteractionOperand_Shape"));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"InteractionOperand");
        return node;
    }

    public Node createInteractionUse_Shape(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.getStyles().add((Object)NotationFactory.eINSTANCE.createHintedDiagramLinkStyle());
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType("InteractionUse_Shape"));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"InteractionUse");
        this.createLabel((View)node, UMLVisualIDRegistry.getType("InteractionUse_NameLabel"));
        this.createLabel((View)node, UMLVisualIDRegistry.getType("InteractionUse_TypeLabel"));
        return node;
    }

    public Node createContinuation_Shape(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType("Continuation_Shape"));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Continuation");
        this.createLabel((View)node, UMLVisualIDRegistry.getType("Continuation_NameLabel"));
        return node;
    }

    public Node createLifeline_Shape(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType("Lifeline_Shape"));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Lifeline");
        this.createLabel((View)node, UMLVisualIDRegistry.getType("Lifeline_NameLabel"));
        return node;
    }

    public Node createActionExecutionSpecification_Shape(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType("ActionExecutionSpecification_Shape"));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"ActionExecutionSpecification");
        return node;
    }

    public Node createBehaviorExecutionSpecification_Shape(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType("BehaviorExecutionSpecification_Shape"));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"BehaviorExecutionSpecification");
        return node;
    }

    public Node createStateInvariant_Shape(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType("StateInvariant_Shape"));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"StateInvariant");
        this.createLabel((View)node, UMLVisualIDRegistry.getType("StateInvariant_NameLabel"));
        this.createLabel((View)node, UMLVisualIDRegistry.getType("StateInvariant_ConstraintLabel"));
        return node;
    }

    public Node createDestructionOccurrenceSpecification_Shape(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType("DestructionOccurrenceSpecification_Shape"));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"DestructionOccurrenceSpecification");
        return node;
    }

    public Node createConstraint_Shape(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType("Constraint_Shape"));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Constraint");
        this.createLabel((View)node, UMLVisualIDRegistry.getType("Constraint_NameLabel"));
        this.createLabel((View)node, UMLVisualIDRegistry.getType("Constraint_BodyLabel"));
        return node;
    }

    public Node createComment_Shape(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType("Comment_Shape"));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Comment");
        this.createLabel((View)node, UMLVisualIDRegistry.getType("Comment_BodyLabel"));
        return node;
    }

    public Node createGate_Shape(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType("Gate_Shape"));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Gate");
        Node gate_NameLabel = this.createLabel((View)node, UMLVisualIDRegistry.getType("Gate_NameLabel"));
        gate_NameLabel.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location gate_NameLabel_Location = (Location)gate_NameLabel.getLayoutConstraint();
        gate_NameLabel_Location.setX(25);
        gate_NameLabel_Location.setY(3);
        PreferenceInitializerForElementHelper.initLabelVisibilityFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"Gate");
        return node;
    }

    public Node createTimeConstraint_Shape(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType("TimeConstraint_Shape"));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"TimeConstraint");
        Node timeConstraint_NameLabel = this.createLabel((View)node, UMLVisualIDRegistry.getType("TimeConstraint_NameLabel"));
        timeConstraint_NameLabel.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location timeConstraint_NameLabel_Location = (Location)timeConstraint_NameLabel.getLayoutConstraint();
        timeConstraint_NameLabel_Location.setX(25);
        timeConstraint_NameLabel_Location.setY(3);
        Node timeConstraint_StereotypeLabel = this.createLabel((View)node, UMLVisualIDRegistry.getType("TimeConstraint_StereotypeLabel"));
        timeConstraint_StereotypeLabel.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location timeConstraint_StereotypeLabel_Location = (Location)timeConstraint_StereotypeLabel.getLayoutConstraint();
        timeConstraint_StereotypeLabel_Location.setX(0);
        timeConstraint_StereotypeLabel_Location.setY(-22);
        return node;
    }

    public Node createTimeObservation_Shape(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(UMLVisualIDRegistry.getType("TimeObservation_Shape"));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)node, (IPreferenceStore)prefStore, (String)"TimeObservation");
        Node timeObservation_NameLabel = this.createLabel((View)node, UMLVisualIDRegistry.getType("TimeObservation_NameLabel"));
        timeObservation_NameLabel.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location timeObservation_NameLabel_Location = (Location)timeObservation_NameLabel.getLayoutConstraint();
        timeObservation_NameLabel_Location.setX(25);
        timeObservation_NameLabel_Location.setY(3);
        Node timeObservation_StereotypeLabel = this.createLabel((View)node, UMLVisualIDRegistry.getType("TimeObservation_StereotypeLabel"));
        timeObservation_StereotypeLabel.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location timeObservation_StereotypeLabel_Location = (Location)timeObservation_StereotypeLabel.getLayoutConstraint();
        timeObservation_StereotypeLabel_Location.setX(0);
        timeObservation_StereotypeLabel_Location.setY(-22);
        return node;
    }

    public Edge createMessage_SynchEdge(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Connector edge = NotationFactory.eINSTANCE.createConnector();
        edge.getStyles().add((Object)NotationFactory.eINSTANCE.createFontStyle());
        RelativeBendpoints bendpoints = NotationFactory.eINSTANCE.createRelativeBendpoints();
        ArrayList<RelativeBendpoint> points = new ArrayList<RelativeBendpoint>(2);
        points.add(new RelativeBendpoint());
        points.add(new RelativeBendpoint());
        bendpoints.setPoints(points);
        edge.setBendpoints((Bendpoints)bendpoints);
        ViewUtil.insertChildView((View)containerView, (View)edge, (int)index, (boolean)persisted);
        edge.setType(UMLVisualIDRegistry.getType("Message_SynchEdge"));
        edge.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"Message");
        Node message_SynchNameLabel = this.createLabel((View)edge, UMLVisualIDRegistry.getType("Message_SynchNameLabel"));
        message_SynchNameLabel.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location message_SynchNameLabel_Location = (Location)message_SynchNameLabel.getLayoutConstraint();
        message_SynchNameLabel_Location.setX(1);
        message_SynchNameLabel_Location.setY(-13);
        Node message_SynchStereotypeLabel = this.createLabel((View)edge, UMLVisualIDRegistry.getType("Message_SynchStereotypeLabel"));
        message_SynchStereotypeLabel.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location message_SynchStereotypeLabel_Location = (Location)message_SynchStereotypeLabel.getLayoutConstraint();
        message_SynchStereotypeLabel_Location.setX(1);
        message_SynchStereotypeLabel_Location.setY(-33);
        PreferenceInitializerForElementHelper.initLabelVisibilityFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"Message");
        return edge;
    }

    public Edge createMessage_AsynchEdge(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Connector edge = NotationFactory.eINSTANCE.createConnector();
        edge.getStyles().add((Object)NotationFactory.eINSTANCE.createFontStyle());
        RelativeBendpoints bendpoints = NotationFactory.eINSTANCE.createRelativeBendpoints();
        ArrayList<RelativeBendpoint> points = new ArrayList<RelativeBendpoint>(2);
        points.add(new RelativeBendpoint());
        points.add(new RelativeBendpoint());
        bendpoints.setPoints(points);
        edge.setBendpoints((Bendpoints)bendpoints);
        ViewUtil.insertChildView((View)containerView, (View)edge, (int)index, (boolean)persisted);
        edge.setType(UMLVisualIDRegistry.getType("Message_AsynchEdge"));
        edge.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"Message");
        Node message_AsynchNameLabel = this.createLabel((View)edge, UMLVisualIDRegistry.getType("Message_AsynchNameLabel"));
        message_AsynchNameLabel.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location message_AsynchNameLabel_Location = (Location)message_AsynchNameLabel.getLayoutConstraint();
        message_AsynchNameLabel_Location.setX(1);
        message_AsynchNameLabel_Location.setY(-13);
        Node message_AsynchStereotypeLabel = this.createLabel((View)edge, UMLVisualIDRegistry.getType("Message_AsynchStereotypeLabel"));
        message_AsynchStereotypeLabel.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location message_AsynchStereotypeLabel_Location = (Location)message_AsynchStereotypeLabel.getLayoutConstraint();
        message_AsynchStereotypeLabel_Location.setX(1);
        message_AsynchStereotypeLabel_Location.setY(-33);
        PreferenceInitializerForElementHelper.initLabelVisibilityFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"Message");
        return edge;
    }

    public Edge createMessage_ReplyEdge(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Connector edge = NotationFactory.eINSTANCE.createConnector();
        edge.getStyles().add((Object)NotationFactory.eINSTANCE.createFontStyle());
        RelativeBendpoints bendpoints = NotationFactory.eINSTANCE.createRelativeBendpoints();
        ArrayList<RelativeBendpoint> points = new ArrayList<RelativeBendpoint>(2);
        points.add(new RelativeBendpoint());
        points.add(new RelativeBendpoint());
        bendpoints.setPoints(points);
        edge.setBendpoints((Bendpoints)bendpoints);
        ViewUtil.insertChildView((View)containerView, (View)edge, (int)index, (boolean)persisted);
        edge.setType(UMLVisualIDRegistry.getType("Message_ReplyEdge"));
        edge.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"Message");
        Node message_ReplyNameLabel = this.createLabel((View)edge, UMLVisualIDRegistry.getType("Message_ReplyNameLabel"));
        message_ReplyNameLabel.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location message_ReplyNameLabel_Location = (Location)message_ReplyNameLabel.getLayoutConstraint();
        message_ReplyNameLabel_Location.setX(1);
        message_ReplyNameLabel_Location.setY(-13);
        Node message_ReplyStereotypeLabel = this.createLabel((View)edge, UMLVisualIDRegistry.getType("Message_ReplyStereotypeLabel"));
        message_ReplyStereotypeLabel.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location message_ReplyStereotypeLabel_Location = (Location)message_ReplyStereotypeLabel.getLayoutConstraint();
        message_ReplyStereotypeLabel_Location.setX(1);
        message_ReplyStereotypeLabel_Location.setY(-33);
        PreferenceInitializerForElementHelper.initLabelVisibilityFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"Message");
        return edge;
    }

    public Edge createMessage_CreateEdge(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Connector edge = NotationFactory.eINSTANCE.createConnector();
        edge.getStyles().add((Object)NotationFactory.eINSTANCE.createFontStyle());
        RelativeBendpoints bendpoints = NotationFactory.eINSTANCE.createRelativeBendpoints();
        ArrayList<RelativeBendpoint> points = new ArrayList<RelativeBendpoint>(2);
        points.add(new RelativeBendpoint());
        points.add(new RelativeBendpoint());
        bendpoints.setPoints(points);
        edge.setBendpoints((Bendpoints)bendpoints);
        ViewUtil.insertChildView((View)containerView, (View)edge, (int)index, (boolean)persisted);
        edge.setType(UMLVisualIDRegistry.getType("Message_CreateEdge"));
        edge.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"Message");
        Node message_CreateNameLabel = this.createLabel((View)edge, UMLVisualIDRegistry.getType("Message_CreateNameLabel"));
        message_CreateNameLabel.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location message_CreateNameLabel_Location = (Location)message_CreateNameLabel.getLayoutConstraint();
        message_CreateNameLabel_Location.setX(1);
        message_CreateNameLabel_Location.setY(-13);
        Node message_CreateStereotypeLabel = this.createLabel((View)edge, UMLVisualIDRegistry.getType("Message_CreateStereotypeLabel"));
        message_CreateStereotypeLabel.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location message_CreateStereotypeLabel_Location = (Location)message_CreateStereotypeLabel.getLayoutConstraint();
        message_CreateStereotypeLabel_Location.setX(1);
        message_CreateStereotypeLabel_Location.setY(-33);
        PreferenceInitializerForElementHelper.initLabelVisibilityFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"Message");
        return edge;
    }

    public Edge createMessage_DeleteEdge(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Connector edge = NotationFactory.eINSTANCE.createConnector();
        edge.getStyles().add((Object)NotationFactory.eINSTANCE.createFontStyle());
        RelativeBendpoints bendpoints = NotationFactory.eINSTANCE.createRelativeBendpoints();
        ArrayList<RelativeBendpoint> points = new ArrayList<RelativeBendpoint>(2);
        points.add(new RelativeBendpoint());
        points.add(new RelativeBendpoint());
        bendpoints.setPoints(points);
        edge.setBendpoints((Bendpoints)bendpoints);
        ViewUtil.insertChildView((View)containerView, (View)edge, (int)index, (boolean)persisted);
        edge.setType(UMLVisualIDRegistry.getType("Message_DeleteEdge"));
        edge.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"Message");
        Node message_DeleteNameLabel = this.createLabel((View)edge, UMLVisualIDRegistry.getType("Message_DeleteNameLabel"));
        message_DeleteNameLabel.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location message_DeleteNameLabel_Location = (Location)message_DeleteNameLabel.getLayoutConstraint();
        message_DeleteNameLabel_Location.setX(1);
        message_DeleteNameLabel_Location.setY(-13);
        Node message_DeleteStereotypeLabel = this.createLabel((View)edge, UMLVisualIDRegistry.getType("Message_DeleteStereotypeLabel"));
        message_DeleteStereotypeLabel.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location message_DeleteStereotypeLabel_Location = (Location)message_DeleteStereotypeLabel.getLayoutConstraint();
        message_DeleteStereotypeLabel_Location.setX(1);
        message_DeleteStereotypeLabel_Location.setY(-33);
        PreferenceInitializerForElementHelper.initLabelVisibilityFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"Message");
        return edge;
    }

    public Edge createMessage_LostEdge(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Connector edge = NotationFactory.eINSTANCE.createConnector();
        edge.getStyles().add((Object)NotationFactory.eINSTANCE.createFontStyle());
        RelativeBendpoints bendpoints = NotationFactory.eINSTANCE.createRelativeBendpoints();
        ArrayList<RelativeBendpoint> points = new ArrayList<RelativeBendpoint>(2);
        points.add(new RelativeBendpoint());
        points.add(new RelativeBendpoint());
        bendpoints.setPoints(points);
        edge.setBendpoints((Bendpoints)bendpoints);
        ViewUtil.insertChildView((View)containerView, (View)edge, (int)index, (boolean)persisted);
        edge.setType(UMLVisualIDRegistry.getType("Message_LostEdge"));
        edge.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"Message");
        Node message_LostNameLabel = this.createLabel((View)edge, UMLVisualIDRegistry.getType("Message_LostNameLabel"));
        message_LostNameLabel.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location message_LostNameLabel_Location = (Location)message_LostNameLabel.getLayoutConstraint();
        message_LostNameLabel_Location.setX(1);
        message_LostNameLabel_Location.setY(-13);
        Node message_LostStereotypeLabel = this.createLabel((View)edge, UMLVisualIDRegistry.getType("Message_LostStereotypeLabel"));
        message_LostStereotypeLabel.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location message_LostStereotypeLabel_Location = (Location)message_LostStereotypeLabel.getLayoutConstraint();
        message_LostStereotypeLabel_Location.setX(1);
        message_LostStereotypeLabel_Location.setY(-33);
        PreferenceInitializerForElementHelper.initLabelVisibilityFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"Message");
        return edge;
    }

    public Edge createMessage_FoundEdge(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Connector edge = NotationFactory.eINSTANCE.createConnector();
        edge.getStyles().add((Object)NotationFactory.eINSTANCE.createFontStyle());
        RelativeBendpoints bendpoints = NotationFactory.eINSTANCE.createRelativeBendpoints();
        ArrayList<RelativeBendpoint> points = new ArrayList<RelativeBendpoint>(2);
        points.add(new RelativeBendpoint());
        points.add(new RelativeBendpoint());
        bendpoints.setPoints(points);
        edge.setBendpoints((Bendpoints)bendpoints);
        ViewUtil.insertChildView((View)containerView, (View)edge, (int)index, (boolean)persisted);
        edge.setType(UMLVisualIDRegistry.getType("Message_FoundEdge"));
        edge.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"Message");
        Node message_FoundNameLabel = this.createLabel((View)edge, UMLVisualIDRegistry.getType("Message_FoundNameLabel"));
        message_FoundNameLabel.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location message_FoundNameLabel_Location = (Location)message_FoundNameLabel.getLayoutConstraint();
        message_FoundNameLabel_Location.setX(1);
        message_FoundNameLabel_Location.setY(-13);
        Node message_FoundStereotypeLabel = this.createLabel((View)edge, UMLVisualIDRegistry.getType("Message_FoundStereotypeLabel"));
        message_FoundStereotypeLabel.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location message_FoundStereotypeLabel_Location = (Location)message_FoundStereotypeLabel.getLayoutConstraint();
        message_FoundStereotypeLabel_Location.setX(1);
        message_FoundStereotypeLabel_Location.setY(-33);
        PreferenceInitializerForElementHelper.initLabelVisibilityFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"Message");
        return edge;
    }

    public Edge createComment_AnnotatedElementEdge(View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Connector edge = NotationFactory.eINSTANCE.createConnector();
        edge.getStyles().add((Object)NotationFactory.eINSTANCE.createFontStyle());
        RelativeBendpoints bendpoints = NotationFactory.eINSTANCE.createRelativeBendpoints();
        ArrayList<RelativeBendpoint> points = new ArrayList<RelativeBendpoint>(2);
        points.add(new RelativeBendpoint());
        points.add(new RelativeBendpoint());
        bendpoints.setPoints(points);
        edge.setBendpoints((Bendpoints)bendpoints);
        ViewUtil.insertChildView((View)containerView, (View)edge, (int)index, (boolean)persisted);
        edge.setType(UMLVisualIDRegistry.getType("Comment_AnnotatedElementEdge"));
        edge.setElement(null);
        return edge;
    }

    public Edge createConstraint_ConstrainedElementEdge(View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Connector edge = NotationFactory.eINSTANCE.createConnector();
        edge.getStyles().add((Object)NotationFactory.eINSTANCE.createFontStyle());
        RelativeBendpoints bendpoints = NotationFactory.eINSTANCE.createRelativeBendpoints();
        ArrayList<RelativeBendpoint> points = new ArrayList<RelativeBendpoint>(2);
        points.add(new RelativeBendpoint());
        points.add(new RelativeBendpoint());
        bendpoints.setPoints(points);
        edge.setBendpoints((Bendpoints)bendpoints);
        ViewUtil.insertChildView((View)containerView, (View)edge, (int)index, (boolean)persisted);
        edge.setType(UMLVisualIDRegistry.getType("Constraint_ConstrainedElementEdge"));
        edge.setElement(null);
        return edge;
    }

    public Edge createGeneralOrdering_Edge(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Connector edge = NotationFactory.eINSTANCE.createConnector();
        edge.getStyles().add((Object)NotationFactory.eINSTANCE.createFontStyle());
        RelativeBendpoints bendpoints = NotationFactory.eINSTANCE.createRelativeBendpoints();
        ArrayList<RelativeBendpoint> points = new ArrayList<RelativeBendpoint>(2);
        points.add(new RelativeBendpoint());
        points.add(new RelativeBendpoint());
        bendpoints.setPoints(points);
        edge.setBendpoints((Bendpoints)bendpoints);
        ViewUtil.insertChildView((View)containerView, (View)edge, (int)index, (boolean)persisted);
        edge.setType(UMLVisualIDRegistry.getType("GeneralOrdering_Edge"));
        edge.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"GeneralOrdering");
        Node generalOrdering_StereotypeLabel = this.createLabel((View)edge, UMLVisualIDRegistry.getType("GeneralOrdering_StereotypeLabel"));
        generalOrdering_StereotypeLabel.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location generalOrdering_StereotypeLabel_Location = (Location)generalOrdering_StereotypeLabel.getLayoutConstraint();
        generalOrdering_StereotypeLabel_Location.setX(1);
        generalOrdering_StereotypeLabel_Location.setY(-33);
        PreferenceInitializerForElementHelper.initLabelVisibilityFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"GeneralOrdering");
        return edge;
    }

    public Edge createConstraint_ContextEdge(View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Connector edge = NotationFactory.eINSTANCE.createConnector();
        edge.getStyles().add((Object)NotationFactory.eINSTANCE.createFontStyle());
        RelativeBendpoints bendpoints = NotationFactory.eINSTANCE.createRelativeBendpoints();
        ArrayList<RelativeBendpoint> points = new ArrayList<RelativeBendpoint>(2);
        points.add(new RelativeBendpoint());
        points.add(new RelativeBendpoint());
        bendpoints.setPoints(points);
        edge.setBendpoints((Bendpoints)bendpoints);
        ViewUtil.insertChildView((View)containerView, (View)edge, (int)index, (boolean)persisted);
        edge.setType(UMLVisualIDRegistry.getType("Constraint_ContextEdge"));
        edge.setElement(null);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        Node constraint_KeywordLabel = this.createLabel((View)edge, UMLVisualIDRegistry.getType("Constraint_KeywordLabel"));
        constraint_KeywordLabel.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location constraint_KeywordLabel_Location = (Location)constraint_KeywordLabel.getLayoutConstraint();
        constraint_KeywordLabel_Location.setX(0);
        constraint_KeywordLabel_Location.setY(60);
        PreferenceInitializerForElementHelper.initLabelVisibilityFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"Undefined");
        return edge;
    }

    public Edge createDurationConstraint_Edge(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Connector edge = NotationFactory.eINSTANCE.createConnector();
        edge.getStyles().add((Object)NotationFactory.eINSTANCE.createFontStyle());
        RelativeBendpoints bendpoints = NotationFactory.eINSTANCE.createRelativeBendpoints();
        ArrayList<RelativeBendpoint> points = new ArrayList<RelativeBendpoint>(2);
        points.add(new RelativeBendpoint());
        points.add(new RelativeBendpoint());
        bendpoints.setPoints(points);
        edge.setBendpoints((Bendpoints)bendpoints);
        ViewUtil.insertChildView((View)containerView, (View)edge, (int)index, (boolean)persisted);
        edge.setType(UMLVisualIDRegistry.getType("DurationConstraint_Edge"));
        edge.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"DurationConstraint");
        Node durationConstraint_NameLabel = this.createLabel((View)edge, UMLVisualIDRegistry.getType("DurationConstraint_NameLabel"));
        durationConstraint_NameLabel.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location durationConstraint_NameLabel_Location = (Location)durationConstraint_NameLabel.getLayoutConstraint();
        durationConstraint_NameLabel_Location.setX(1);
        durationConstraint_NameLabel_Location.setY(-13);
        Node durationConstraint_StereotypeLabel = this.createLabel((View)edge, UMLVisualIDRegistry.getType("DurationConstraint_StereotypeLabel"));
        durationConstraint_StereotypeLabel.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location durationConstraint_StereotypeLabel_Location = (Location)durationConstraint_StereotypeLabel.getLayoutConstraint();
        durationConstraint_StereotypeLabel_Location.setX(1);
        durationConstraint_StereotypeLabel_Location.setY(-33);
        PreferenceInitializerForElementHelper.initLabelVisibilityFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"DurationConstraint");
        return edge;
    }

    public Edge createDurationObservation_Edge(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Connector edge = NotationFactory.eINSTANCE.createConnector();
        edge.getStyles().add((Object)NotationFactory.eINSTANCE.createFontStyle());
        RelativeBendpoints bendpoints = NotationFactory.eINSTANCE.createRelativeBendpoints();
        ArrayList<RelativeBendpoint> points = new ArrayList<RelativeBendpoint>(2);
        points.add(new RelativeBendpoint());
        points.add(new RelativeBendpoint());
        bendpoints.setPoints(points);
        edge.setBendpoints((Bendpoints)bendpoints);
        ViewUtil.insertChildView((View)containerView, (View)edge, (int)index, (boolean)persisted);
        edge.setType(UMLVisualIDRegistry.getType("DurationObservation_Edge"));
        edge.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        PreferenceInitializerForElementHelper.initFontStyleFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"DurationObservation");
        Node durationObservation_NameLabel = this.createLabel((View)edge, UMLVisualIDRegistry.getType("DurationObservation_NameLabel"));
        durationObservation_NameLabel.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location durationObservation_NameLabel_Location = (Location)durationObservation_NameLabel.getLayoutConstraint();
        durationObservation_NameLabel_Location.setX(1);
        durationObservation_NameLabel_Location.setY(-13);
        Node durationObservation_StereotypeLabel = this.createLabel((View)edge, UMLVisualIDRegistry.getType("DurationObservation_StereotypeLabel"));
        durationObservation_StereotypeLabel.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        Location durationObservation_StereotypeLabel_Location = (Location)durationObservation_StereotypeLabel.getLayoutConstraint();
        durationObservation_StereotypeLabel_Location.setX(1);
        durationObservation_StereotypeLabel_Location.setY(-33);
        PreferenceInitializerForElementHelper.initLabelVisibilityFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"DurationObservation");
        return edge;
    }

    protected void stampShortcut(View containerView, Node target) {
        if (!"PapyrusUMLSequenceDiagram".equals(UMLVisualIDRegistry.getModelID(containerView))) {
            EAnnotation shortcutAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
            shortcutAnnotation.setSource("Shortcut");
            shortcutAnnotation.getDetails().put((Object)"modelID", (Object)"PapyrusUMLSequenceDiagram");
            target.getEAnnotations().add((Object)shortcutAnnotation);
        }
    }

    protected Node createLabel(View owner, String hint) {
        DecorationNode rv = NotationFactory.eINSTANCE.createDecorationNode();
        rv.setType(hint);
        ViewUtil.insertChildView((View)owner, (View)rv, (int)-1, (boolean)true);
        return rv;
    }

    protected Node createCompartment(View owner, String hint, boolean canCollapse, boolean hasTitle, boolean canSort, boolean canFilter) {
        BasicCompartment rv = NotationFactory.eINSTANCE.createBasicCompartment();
        rv.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        if (hasTitle) {
            TitleStyle ts = NotationFactory.eINSTANCE.createTitleStyle();
            rv.getStyles().add((Object)ts);
        }
        if (canSort) {
            rv.getStyles().add((Object)NotationFactory.eINSTANCE.createSortingStyle());
        }
        if (canFilter) {
            rv.getStyles().add((Object)NotationFactory.eINSTANCE.createFilteringStyle());
        }
        rv.setType(hint);
        ViewUtil.insertChildView((View)owner, (View)rv, (int)-1, (boolean)true);
        return rv;
    }

    protected EObject getSemanticElement(IAdaptable semanticAdapter) {
        if (semanticAdapter == null) {
            return null;
        }
        EObject eObject = (EObject)semanticAdapter.getAdapter(EObject.class);
        if (eObject != null) {
            return EMFCoreUtil.resolve((TransactionalEditingDomain)TransactionUtil.getEditingDomain((EObject)eObject), (EObject)eObject);
        }
        return null;
    }

    protected IElementType getSemanticElementType(IAdaptable semanticAdapter) {
        if (semanticAdapter == null) {
            return null;
        }
        return (IElementType)semanticAdapter.getAdapter(IElementType.class);
    }
}

