/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.ui.rename;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.nebula.widgets.nattable.Messages;
import org.eclipse.nebula.widgets.nattable.style.editor.AbstractEditorPanel;
import org.eclipse.nebula.widgets.nattable.ui.rename.HeaderRenameDialog;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class HeaderLabelPanel
extends AbstractEditorPanel<String> {
    private Text textField;
    private final String currentLabel;
    private final String newLabel;
    private final HeaderRenameDialog.RenameDialogLabels dialogLabels;

    public HeaderLabelPanel(Composite parent, String currentLabel, String newLabel, HeaderRenameDialog.RenameDialogLabels dialogLabels) {
        super(parent, 0);
        this.currentLabel = currentLabel;
        this.newLabel = newLabel;
        this.dialogLabels = dialogLabels;
        this.init();
    }

    private void init() {
        GridLayout gridLayout = new GridLayout(2, false);
        this.setLayout((Layout)gridLayout);
        if (this.currentLabel != null) {
            Label label = new Label((Composite)this, 0);
            label.setText(Messages.getString("HeaderLabel.original"));
            Label originalLabel = new Label((Composite)this, 0);
            originalLabel.setText(this.currentLabel);
        }
        Label renameLabel = new Label((Composite)this, 0);
        renameLabel.setText(Messages.getString("HeaderLabel.rename"));
        this.textField = new Text((Composite)this, 2048);
        GridDataFactory.fillDefaults().grab(true, false).minSize(GUIHelper.convertHorizontalPixelToDpi(200, true), -1).applyTo((Control)this.textField);
        if (this.newLabel != null && this.newLabel.length() > 0) {
            this.textField.setText(this.newLabel);
            this.textField.selectAll();
        }
    }

    @Override
    public void edit(String newColumnHeaderLabel) throws Exception {
        if (newColumnHeaderLabel != null && newColumnHeaderLabel.length() > 0) {
            this.textField.setText(newColumnHeaderLabel);
            this.textField.selectAll();
        }
    }

    @Override
    public String getEditorName() {
        return this.dialogLabels.editorName;
    }

    @Override
    public String getNewValue() {
        if (this.textField.isEnabled() && this.textField.getText() != null && this.textField.getText().length() > 0) {
            return this.textField.getText();
        }
        return null;
    }
}

