/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.junit.framework.runner;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.papyrus.junit.framework.runner.ITestSuiteClass;
import org.eclipse.papyrus.junit.framework.runner.SuiteSpot;
import org.junit.runners.Suite;
import org.junit.runners.model.FrameworkField;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.TestClass;

public class AllTestsRunner
extends Suite {
    public AllTestsRunner(Class<?> clazz) throws InitializationError {
        super(clazz, (Class[])AllTestsRunner.getSuites(clazz));
    }

    static Class<?>[] getSuites(Class<?> clazz) {
        ArrayList suites = new ArrayList();
        TestClass testClass = new TestClass(clazz);
        ArrayList<ITestSuiteClass> suiteClassSpecs = new ArrayList<ITestSuiteClass>();
        List suiteSpots = testClass.getAnnotatedFields(SuiteSpot.class);
        for (FrameworkField spot : suiteSpots) {
            if (!spot.isStatic()) continue;
            try {
                Object value = spot.get(null);
                Iterable<Object> listValue = value instanceof Object[] ? Arrays.asList((Object[])value) : (value instanceof Iterable ? (Iterable)value : Collections.emptyList());
                for (Object t : listValue) {
                    if (!(t instanceof ITestSuiteClass)) continue;
                    suiteClassSpecs.add((ITestSuiteClass)t);
                }
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        if (suiteClassSpecs.isEmpty()) {
            System.err.println("No suite classes specified in class " + clazz.getName());
        } else {
            for (ITestSuiteClass testSuiteClass : suiteClassSpecs) {
                Class<?> class_ = testSuiteClass.getMainTestSuiteClass();
                if (class_ != null) {
                    suites.add(class_);
                    continue;
                }
                System.err.println(String.valueOf(testSuiteClass) + " does not give a correct test suite class");
            }
        }
        return suites.toArray(new Class[0]);
    }
}

