/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.junit.util.diagram;

import java.util.List;
import java.util.Optional;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.papyrus.sirius.junit.utils.diagram.creation.graphical.checker.GraphicalOwnerUtils;
import org.eclipse.papyrus.sirius.junit.utils.rules.SiriusDiagramEditorFixture;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.diagram.business.api.query.DDiagramQuery;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Package;
import org.junit.Assert;
import org.junit.Rule;

public abstract class AbstractSiriusDiagramTests {
    private boolean synchronization = false;
    @Rule
    public final SiriusDiagramEditorFixture fixture = new SiriusDiagramEditorFixture();

    public void setSynchronization(boolean value) {
        this.synchronization = value;
    }

    public boolean isSynchronization() {
        return this.synchronization;
    }

    protected void checkSiriusDiagramSynchronization(boolean isSynchronized) {
        DSemanticDiagram siriusDiagram = this.fixture.getActiveSiriusDiagram();
        Assert.assertNotNull((String)"We don't found a Sirius active diagram", (Object)siriusDiagram);
        Assert.assertEquals((String)"The synchronization status of the diagram is not the expected one", (Object)isSynchronized, (Object)siriusDiagram.isSynchronized());
    }

    protected AbstractDNode getNodeFromContainer(String elementNameNode, String mappingTypeName, EObject graphicalContainer) {
        return this.getNodeFromContainer(elementNameNode, mappingTypeName, graphicalContainer, null);
    }

    /*
     * WARNING - void declaration
     */
    protected AbstractDNode getNodeFromContainer(String elementNameNode, String mappingTypeName, EObject graphicalContainer, EObject semanticContainer) {
        this.checkSiriusDiagramSynchronization(this.isSynchronization());
        Assert.assertTrue((boolean)(this.getRootElement() instanceof Namespace));
        Namespace rootElement = (Namespace)this.getRootElement();
        Object element = null;
        if (graphicalContainer instanceof DDiagramElementContainer) {
            EObject semanticParent = null;
            semanticParent = semanticContainer == null ? (EObject)((DRepresentationElement)graphicalContainer).getSemanticElements().get(0) : semanticContainer;
            for (EObject eObject : semanticParent.eContents()) {
                if (!(eObject instanceof NamedElement) || !elementNameNode.equals(((NamedElement)eObject).getName())) continue;
                element = (NamedElement)eObject;
                break;
            }
        } else if (graphicalContainer instanceof DSemanticDiagram) {
            element = rootElement.getName().equals(elementNameNode) ? rootElement : rootElement.getMember(elementNameNode);
        }
        Assert.assertNotNull((String)"We can't find the semantic element", element);
        Diagram diagram = this.getDiagram();
        Assert.assertNotNull((String)"We can't find the diagram", (Object)diagram);
        for (EObject eObject : GraphicalOwnerUtils.getChildren(graphicalContainer)) {
            void abstractNode;
            EObject eObject2 = eObject;
            if (!(eObject2 instanceof AbstractDNode)) continue;
            AbstractDNode cfr_ignored_0 = (AbstractDNode)eObject2;
            AbstractDNode cfr_ignored_1 = (AbstractDNode)eObject2;
            if (!mappingTypeName.equals(((AbstractDNode)eObject).getMapping().getName()) || !element.equals(abstractNode.getSemanticElements().get(0))) continue;
            return abstractNode;
        }
        return null;
    }

    protected Element getRootElement() {
        return this.fixture.getModel();
    }

    protected AbstractDNode getNodeFromDiagram(String elementNameNode, String mappingTypeName) {
        return this.getNodeFromContainer(elementNameNode, mappingTypeName, (EObject)this.getDDiagram());
    }

    protected List<DDiagramElement> getElementsFromDiagram(String elementNameNode, String mappingTypeName) {
        DDiagramQuery dDiagramQuery = new DDiagramQuery((DDiagram)this.getDDiagram());
        return dDiagramQuery.getAllDiagramElements().stream().filter(ddiagramElement -> this.hasSameMappingTypeOrIsNull(mappingTypeName, (DDiagramElement)ddiagramElement) && this.hasSameNameOrIsNull(elementNameNode, (DDiagramElement)ddiagramElement)).collect(Collectors.toList());
    }

    protected List<DDiagramElement> getElementsFromDiagramBySemanticName(String semanticTargetName, String mappingTypeName) {
        DDiagramQuery dDiagramQuery = new DDiagramQuery((DDiagram)this.getDDiagram());
        return dDiagramQuery.getAllDiagramElements().stream().filter(ddiagramElement -> this.hasSameMappingTypeOrIsNull(mappingTypeName, (DDiagramElement)ddiagramElement) && this.hasSameTargetNameOrIsNull(semanticTargetName, (DDiagramElement)ddiagramElement)).collect(Collectors.toList());
    }

    protected Optional<NamedElement> getElementByNameFromRoot(String elementName) {
        return this.getElementByName(this.getRootElement(), elementName);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Optional<NamedElement> getElementByName(Element container, String elementName) {
        void namedElement2;
        Optional<NamedElement> result = Optional.empty();
        Element element = container;
        if (!(element instanceof NamedElement)) return StreamSupport.stream(Spliterators.spliteratorUnknownSize(container.eAllContents(), 256), false).filter(NamedElement.class::isInstance).map(NamedElement.class::cast).filter(namedElement -> namedElement.getName() != null && namedElement.getName().equals(elementName)).findFirst();
        NamedElement namedElement3 = (NamedElement)element;
        NamedElement cfr_ignored_0 = (NamedElement)element;
        if (!elementName.equals(namedElement2.getName())) return StreamSupport.stream(Spliterators.spliteratorUnknownSize(container.eAllContents(), 256), false).filter(NamedElement.class::isInstance).map(NamedElement.class::cast).filter(namedElement -> namedElement.getName() != null && namedElement.getName().equals(elementName)).findFirst();
        return Optional.of(namedElement2);
    }

    private boolean hasSameMappingTypeOrIsNull(String mappingTypeName, DDiagramElement ddiagramElement) {
        return mappingTypeName != null && ddiagramElement.getDiagramElementMapping().getName().equals(mappingTypeName) || mappingTypeName == null;
    }

    private boolean hasSameNameOrIsNull(String name, DDiagramElement ddiagramElement) {
        return name != null && ddiagramElement.getName().equals(name) || name == null;
    }

    private boolean hasSameTargetNameOrIsNull(String name, DDiagramElement ddiagramElement) {
        Optional<EObject> target = Optional.ofNullable(ddiagramElement.getTarget());
        boolean hasSameName = target.filter(NamedElement.class::isInstance).filter(namedElement -> ((NamedElement)namedElement).getName().equals(name)).isPresent();
        boolean hasSameBody = target.filter(Comment.class::isInstance).filter(comment -> ((Comment)comment).getBody().equals(name)).isPresent();
        return name != null && (hasSameName || hasSameBody) || name == null;
    }

    protected DEdge getEdgeFromDiagram(EdgeTarget graphicalSource, EdgeTarget graphicalTarget, String mappingTypeName) {
        this.checkSiriusDiagramSynchronization(this.isSynchronization());
        DEdge foundEdge = null;
        for (DEdge dEdge : this.getDDiagram().getEdges()) {
            if (!graphicalSource.equals(dEdge.getSourceNode()) || !graphicalTarget.equals(dEdge.getTargetNode()) || !mappingTypeName.equals(dEdge.getMapping().getName())) continue;
            foundEdge = dEdge;
            break;
        }
        Assert.assertNotNull((String)"Edge not found the diagram", foundEdge);
        return foundEdge;
    }

    protected final DDiagramElementContainer getDDiagramElementContainerInContainer(DNodeContainer container, String subNodeMappingType) {
        for (DDiagramElement subNode : container.getOwnedDiagramElements()) {
            if (!(subNode instanceof DDiagramElementContainer) || !subNode.getMapping().getName().equals(subNodeMappingType)) continue;
            return (DDiagramElementContainer)subNode;
        }
        return null;
    }

    public final Diagram getDiagram() {
        return this.fixture.getActiveDiagram().getDiagramView();
    }

    public final DSemanticDiagram getDDiagram() {
        return (DSemanticDiagram)this.getDiagram().getElement();
    }

    public final Package getModel() {
        return this.fixture.getModel();
    }
}

