/*****************************************************************************
 * Copyright (c) 2022 CEA LIST
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *  Vincent Lorenzo (CEA LIST) <vincent.lorenzo@cea.fr> - Initial API and implementation
 *****************************************************************************/
package org.eclipse.papyrus.sirius.uml.diagram.clazz.internal.constants;

/**
 * This class provides mapping types for Sirius Class Diagram odesign
 */
public class MappingTypes {

	private MappingTypes() {
		// to prevent instantiation
	}

	/*
	 * The AssociationClass graphical representation is composed by three elements
	 */
	/**
	 * The ID of the main AssociationClass link. This is the link looking like an Association.
	 */
	public static final String ASSOCIATIONCLASS_LINK = "CD_AssociationClass_Link";//$NON-NLS-1$

	/**
	 * The ID of the AssociationClass node. This node looks like a Class.
	 */
	public static final String ASSOCIATIONCLASS_NODE = "CD_AssociationClass_Node";//$NON-NLS-1$

	/**
	 * The ID of the AssociationClass link relying the 'Association' part to the 'Class' part of the AssociationClass link.
	 */
	public static final String ASSOCIATIONCLASS_NODE_TO_LINK = "CD_AssociationClass_NodeToLink";//$NON-NLS-1$
	
	public static final String ASSOCIATIONCLASS_NODE_ATTRIBUTES_COMPARTMENT_TYPE = "CD_AssociationClassAttributesCompartment"; //$NON-NLS-1$

	public static final String ASSOCIATIONCLASS_NODE_OPERATIONS_COMPARTMENT_TYPE = "CD_AssociationClassOperationsCompartment"; //$NON-NLS-1$

	public static final String ASSOCIATIONCLASS_NODE_NESTED_CLASSIFIERS_COMPARTMENT_TYPE = "CD_AssociationClassNestedClassifiersCompartment"; //$NON-NLS-1$
	
	public static final String CLASS_LABEL_NODE_TYPE = "CD_ClassLabelNode"; //$NON-NLS-1$

	public static final String CLASS_NODE_TYPE = "CD_Class"; //$NON-NLS-1$

	public static final String CLASS_NODE_ATTRIBUTES_COMPARTMENT_TYPE = "CD_ClassAttributesCompartment"; //$NON-NLS-1$

	public static final String CLASS_NODE_OPERATIONS_COMPARTMENT_TYPE = "CD_ClassOperationsCompartment"; //$NON-NLS-1$

	public static final String CLASS_NODE_NESTED_CLASSIFIERS_COMPARTMENT_TYPE = "CD_ClassNestedClassifiersCompartment"; //$NON-NLS-1$

	public static final String COMMENT_NODE_TYPE = "CD_Comment"; //$NON-NLS-1$

	public static final String COMPONENT_NODE_TYPE = "CD_Component"; //$NON-NLS-1$

	public static final String COMPONENT_NODE_ATTRIBUTES_COMPARTMENT_TYPE = "CD_ComponentAttributesCompartment"; //$NON-NLS-1$

	public static final String COMPONENT_NODE_OPERATIONS_COMPARTMENT_TYPE = "CD_ComponentOperationsCompartment"; //$NON-NLS-1$

	public static final String COMPONENT_NODE_NESTED_CLASSIFIERS_COMPARTMENT_TYPE = "CD_ComponentNestedClassifiersCompartment"; //$NON-NLS-1$

	public static final String CONSTRAINT_NODE_TYPE = "CD_Constraint"; //$NON-NLS-1$

	public static final String DATATYPE_LABEL_NODE_TYPE = "CD_DataTypeLabelNode"; //$NON-NLS-1$

	public static final String DATATYPE_NODE_TYPE = "CD_DataType"; //$NON-NLS-1$

	public static final String DATATYPE_NODE_ATTRIBUTES_COMPARTMENT_TYPE = "CD_DataTypeAttributesCompartment"; //$NON-NLS-1$

	public static final String DATATYPE_NODE_OPERATIONS_COMPARTMENT_TYPE = "CD_DataTypeOperationsCompartment"; //$NON-NLS-1$

	public static final String ENUMERATION_LABEL_NODE_TYPE = "CD_EnumerationLabelNode"; //$NON-NLS-1$

	public static final String ENUMERATION_NODE_TYPE = "CD_Enumeration"; //$NON-NLS-1$

	public static final String ENUMERATION_NODE_LITERALS_COMPARTMENT_TYPE = "CD_EnumerationLiteralsCompartment"; //$NON-NLS-1$

	public static final String INFORMATION_ITEM_NODE_TYPE = "CD_InformationItem"; //$NON-NLS-1$

	public static final String INSTANCESPECIFICATION_NODE_TYPE = "CD_InstanceSpecification_Node"; //$NON-NLS-1$

	public static final String INSTANCESPECIFICATION_NODE_SLOTS_COMPARTMENT_TYPE = "CD_InstanceSpecificationSlotsCompartment"; //$NON-NLS-1$

	public static final String INTERFACE_LABEL_NODE_TYPE = "CD_InterfaceLabelNode"; //$NON-NLS-1$

	public static final String INTERFACE_NODE_TYPE = "CD_Interface"; //$NON-NLS-1$

	public static final String INTERFACE_NODE_ATTRIBUTES_COMPARTMENT_TYPE = "CD_InterfaceAttributesCompartment"; //$NON-NLS-1$

	public static final String INTERFACE_NODE_OPERATIONS_COMPARTMENT_TYPE = "CD_InterfaceOperationsCompartment"; //$NON-NLS-1$

	public static final String INTERFACE_NODE_NESTED_CLASSIFIERS_COMPARTMENT_TYPE = "CD_InterfaceNestedClassifiersCompartment"; //$NON-NLS-1$

	public static final String MODEL_NODE_TYPE = "CD_Model"; //$NON-NLS-1$

	public static final String MODEL_NODE_PACKAGEDELEMENTS_COMPARTMENTS_TYPE = "CD_ModelPackagedElementsCompartment"; //$NON-NLS-1$

	public static final String OPERATION_LABEL_NODE_TYPE = "CD_OperationLabelNode"; //$NON-NLS-1$

	public static final String PACKAGE_NODE_TYPE = "CD_Package"; //$NON-NLS-1$

	public static final String PACKAGE_NODE_PACKAGEDELEMENTS_COMPARTMENTS_TYPE = "CD_PackagePackagedElementsCompartment"; //$NON-NLS-1$

	public static final String PRIMITIVETYPE_NODE_TYPE = "CD_PrimitiveType"; //$NON-NLS-1$

	public static final String PRIMITIVETYPE_NODE_ATTRIBUTES_COMPARTMENT_TYPE = "CD_PrimitiveTypeAttributesCompartment"; //$NON-NLS-1$

	public static final String PRIMITIVETYPE_NODE_OPERATIONS_COMPARTMENT_TYPE = "CD_PrimitiveTypeOperationsCompartment"; //$NON-NLS-1$

	public static final String PRIMITIVETYPE_LABEL_NODE_TYPE = "CD_PrimitiveTypeLabelNode"; //$NON-NLS-1$

	public static final String PROPERTY_LABEL_NODE_TYPE = "CD_PropertyLabelNode"; //$NON-NLS-1$

	public static final String RECEPTION_LABEL_NODE_TYPE = "CD_ReceptionLabelNode"; //$NON-NLS-1$

	public static final String SIGNAL_LABEL_NODE_TYPE = "CD_SignalLabelNode"; //$NON-NLS-1$

	public static final String SIGNAL_NODE_TYPE = "CD_Signal"; //$NON-NLS-1$

	public static final String SIGNAL_NODE_ATTRIBUTES_COMPARTMENT_TYPE = "CD_SignalAttributesCompartment"; //$NON-NLS-1$

	public static final String SLOT_LABEL_NODE_TYPE = "CD_SlotLabelNode"; //$NON-NLS-1$

}
