/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.uml.diagram.compositestructure.services;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.papyrus.sirius.uml.diagram.common.Activator;
import org.eclipse.papyrus.sirius.uml.diagram.common.core.services.AbstractDiagramServices;
import org.eclipse.papyrus.sirius.uml.diagram.common.core.services.EditableChecker;
import org.eclipse.papyrus.sirius.uml.diagram.common.core.services.RepresentationQuerier;
import org.eclipse.papyrus.sirius.uml.diagram.common.services.CommonDiagramServices;
import org.eclipse.papyrus.sirius.uml.diagram.common.services.DomainBasedEdgeServices;
import org.eclipse.papyrus.sirius.uml.diagram.common.services.ReconnectServices;
import org.eclipse.papyrus.uml.domain.services.IEditableChecker;
import org.eclipse.papyrus.uml.domain.services.IViewQuerier;
import org.eclipse.papyrus.uml.domain.services.UMLHelper;
import org.eclipse.papyrus.uml.domain.services.create.ElementDomainBasedEdgeCreationChecker;
import org.eclipse.papyrus.uml.domain.services.create.ICreator;
import org.eclipse.papyrus.uml.domain.services.create.diagrams.CompositeStructureDiagramElementCreator;
import org.eclipse.papyrus.uml.domain.services.edges.IDomainBasedEdgeContainerProvider;
import org.eclipse.papyrus.uml.domain.services.edges.diagrams.CompositeStructureDomainBasedEdgeContainerProvider;
import org.eclipse.papyrus.uml.domain.services.status.CheckStatus;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.CollaborationUse;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;

public class CompositeStructureDiagramServices
extends AbstractDiagramServices {
    private static final String NESTED_CLASSIFIER = "nestedClassifier";
    private static final String PACKAGED_ELEMENT = "packagedElement";

    public EObject createStructuredClassifierCSD(Element parent, String type, DSemanticDecorator targetView) {
        EObject result = null;
        if (parent == null) {
            Activator.log.warn("Unable to create an element on nothing");
        } else if (parent instanceof Package) {
            result = this.createCSD(parent, type, PACKAGED_ELEMENT, targetView);
        } else if (parent instanceof Class) {
            result = this.createCSD(parent, type, NESTED_CLASSIFIER, targetView);
        }
        return result;
    }

    public EObject createCSD(Element parent, String type, String referenceName, DSemanticDecorator targetView) {
        CommonDiagramServices commonDiagramServices = new CommonDiagramServices();
        CompositeStructureDiagramElementCreator compositeStructureDiagramElementCreator = CompositeStructureDiagramElementCreator.buildDefault((ECrossReferenceAdapter)this.getECrossReferenceAdapter((EObject)parent), (IEditableChecker)new EditableChecker());
        return commonDiagramServices.createElement(parent, type, referenceName, targetView, (ICreator)compositeStructureDiagramElementCreator);
    }

    public void createDependencyCSD(EObject source, EObject target, String type, DSemanticDecorator sourceView, DSemanticDecorator targetView) {
        if (source instanceof CollaborationUse) {
            this.createDomainBasedEdgeCSD(source, target, type, UMLPackage.eINSTANCE.getCollaborationUse_RoleBinding().getName(), sourceView, targetView);
        } else {
            this.createDomainBasedEdgeCSD(source, target, type, UMLPackage.eINSTANCE.getPackage_PackagedElement().getName(), sourceView, targetView);
        }
    }

    public EObject createDomainBasedEdgeCSD(EObject source, EObject target, String type, String containementReferenceName, DSemanticDecorator sourceView, DSemanticDecorator targetView) {
        DomainBasedEdgeServices domainBasedEdgeServices = new DomainBasedEdgeServices();
        return domainBasedEdgeServices.createDomainBasedEdge(source, target, type, containementReferenceName, sourceView, targetView, (IDomainBasedEdgeContainerProvider)CompositeStructureDomainBasedEdgeContainerProvider.buildDefault((IEditableChecker)new EditableChecker()));
    }

    public boolean canCreateDomainBasedEdgeCSD(EObject source, EObject target, String type, String containementReferenceName, DSemanticDecorator sourceView, DSemanticDecorator targetView) {
        boolean canCreate = true;
        RepresentationQuerier representationQuery = new RepresentationQuerier((Object)((DDiagramElement)sourceView).getParentDiagram());
        CheckStatus canCreateStatus = new ElementDomainBasedEdgeCreationChecker().canCreate(source, target, type, containementReferenceName, (IViewQuerier)representationQuery, (Object)sourceView, (Object)targetView);
        canCreate = canCreateStatus.isValid();
        if (canCreate) {
            CompositeStructureDomainBasedEdgeContainerProvider containerProvider = CompositeStructureDomainBasedEdgeContainerProvider.buildDefault((IEditableChecker)new EditableChecker());
            EClass eClass = UMLHelper.toEClass((String)type);
            if (eClass != null) {
                EObject newInstance = UMLFactory.eINSTANCE.create(eClass);
                EObject container = containerProvider.getContainer(source, target, newInstance, (IViewQuerier)representationQuery, (Object)sourceView, (Object)targetView);
                canCreate = container != null;
            }
        }
        return canCreate;
    }

    public boolean canReconnectSourceCSD(EObject semanticElementEdge, DSemanticDecorator edgeView, EObject oldSource, EObject newSource, DSemanticDecorator newSourceView) {
        ReconnectServices reconnectServices = new ReconnectServices();
        CompositeStructureDomainBasedEdgeContainerProvider containerProvider = CompositeStructureDomainBasedEdgeContainerProvider.buildDefault((IEditableChecker)new EditableChecker());
        return reconnectServices.canReconnectSource(semanticElementEdge, edgeView, oldSource, newSource, newSourceView, (IDomainBasedEdgeContainerProvider)containerProvider);
    }

    public boolean canReconnectTargetCSD(EObject semanticElementEdge, DSemanticDecorator edgeView, EObject oldTarget, EObject newTarget, DSemanticDecorator newTargetView) {
        ReconnectServices reconnectServices = new ReconnectServices();
        CompositeStructureDomainBasedEdgeContainerProvider containerProvider = CompositeStructureDomainBasedEdgeContainerProvider.buildDefault((IEditableChecker)new EditableChecker());
        return reconnectServices.canReconnectTarget(semanticElementEdge, edgeView, oldTarget, newTarget, newTargetView, (IDomainBasedEdgeContainerProvider)containerProvider);
    }
}

