/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.properties.ui.widgets;

import org.eclipse.papyrus.infra.properties.ui.widgets.AbstractPropertyEditor;
import org.eclipse.papyrus.infra.widgets.editors.AbstractValueEditor;
import org.eclipse.papyrus.infra.widgets.editors.BrowseFileEditor;
import org.eclipse.swt.widgets.Composite;

public class BrowseFilePropertyEditor
extends AbstractPropertyEditor {
    private BrowseFileEditor browseFileEditor = null;
    protected String[] filterExtensions = null;
    protected String[] filterNames = null;
    protected boolean allowWorkspace = true;
    protected boolean allowFileSystem = true;

    public BrowseFilePropertyEditor(Composite parent, int style) {
        this.browseFileEditor = this.createBrowseFileEditor(parent, style);
        super.setEditor((AbstractValueEditor)this.browseFileEditor);
    }

    public void setButtonLabel(String buttonLabel) {
        this.browseFileEditor.setButtonLabel(buttonLabel);
    }

    public String getButtonLabel() {
        return this.browseFileEditor.getButtonLabel();
    }

    private BrowseFileEditor createBrowseFileEditor(Composite parent, int style) {
        return new BrowseFileEditor(parent, style);
    }

    public void setFilterExtensions(String[] filterExtensions) {
        this.filterExtensions = filterExtensions;
        this.checkFilters();
    }

    public String[] getFilterExtensions() {
        return this.filterExtensions;
    }

    public void setFilterNames(String[] filterNames) {
        this.filterNames = filterNames;
        this.checkFilters();
    }

    public String[] getFilterNames() {
        return this.filterNames;
    }

    protected void checkFilters() {
        if (this.filterExtensions != null && this.filterNames != null) {
            this.browseFileEditor.setFilters(this.filterExtensions, this.filterNames);
        }
    }

    public void setAllowWorkspace(boolean allowWorkspace) {
        this.allowWorkspace = allowWorkspace;
        this.browseFileEditor.setAllowWorkspace(allowWorkspace);
    }

    public boolean getAllowWorkspace() {
        return this.allowWorkspace;
    }

    public void setAllowFileSystem(boolean allowFileSystem) {
        this.allowFileSystem = allowFileSystem;
        this.browseFileEditor.setAllowFileSystem(allowFileSystem);
    }

    public boolean getAllowFileSystem() {
        return this.allowFileSystem;
    }
}

