/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.deployment.custom.figure.nodes;

import java.util.List;
import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.papyrus.uml.diagram.deployment.custom.figure.nodes.NodeFigure;

class NodeLayoutManager
extends AbstractLayout {
    protected final int GAP_X = 10;
    protected final int GAP_Y = 5;
    private final NodeFigure nodeFigure;

    NodeLayoutManager(NodeFigure nodeFigure) {
        this.nodeFigure = nodeFigure;
    }

    protected Dimension calculatePreferredSize(IFigure container, int hint, int hint2) {
        int minimumWith = 0;
        int minimumHeight = 0;
        if (this.nodeFigure.getNameLabel() != null) {
            if (this.nodeFigure.getNameLabel().getPreferredSize().width > minimumWith) {
                minimumWith = this.nodeFigure.getNameLabel().getPreferredSize().width;
            }
            minimumHeight += this.nodeFigure.getNameLabel().getPreferredSize().height;
        }
        return new Dimension(minimumWith, minimumHeight);
    }

    public void layout(IFigure container) {
        List childrenList = container.getChildren();
        int i = 0;
        while (i < container.getChildren().size()) {
            Rectangle bound = new Rectangle(((IFigure)childrenList.get(i)).getBounds());
            IFigure fig = (IFigure)childrenList.get(i);
            fig.invalidate();
            Dimension pref = ((IFigure)childrenList.get(i)).getPreferredSize();
            fig.invalidate();
            Dimension prefConstraint = ((IFigure)childrenList.get(i)).getPreferredSize(container.getBounds().width - 40, -1);
            if (pref.width < prefConstraint.width) {
                bound.setSize(pref);
            } else {
                bound.setSize(prefConstraint);
            }
            if (((IFigure)childrenList.get(i)).equals(this.nodeFigure.iconNode)) {
                Rectangle boundName = this.nodeFigure.getNameLabel().getBounds().getCopy();
                boundName.x += 5;
                this.nodeFigure.iconNode.setBounds(new Rectangle(boundName.getTopRight(), new Dimension(16, 16)));
            } else {
                if (i > 0) {
                    bound.x = this.nodeFigure.getBounds().x + 10;
                    bound.y = ((IFigure)childrenList.get((int)(i - 1))).getBounds().getBottomLeft().y + 1;
                } else {
                    bound.x = this.nodeFigure.getBounds().x + 10;
                    bound.y = this.nodeFigure.getBounds().y + 5 + this.nodeFigure.SPACE_FOR_PERSPECTIVE;
                }
                ((IFigure)childrenList.get(i)).setBounds(bound);
            }
            ++i;
        }
        Rectangle lastRectangle = this.nodeFigure.getCompositeCompartmentFigure().getBounds();
        lastRectangle.x = container.getBounds().x;
        lastRectangle.height = this.nodeFigure.getBounds().y + this.nodeFigure.getBounds().height - lastRectangle.y;
        lastRectangle.width = this.nodeFigure.getBounds().width - this.nodeFigure.SPACE_FOR_PERSPECTIVE;
        this.nodeFigure.getGMFCompositeContainer();
    }
}

