/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.resource;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.papyrus.infra.emf.Activator;
import org.eclipse.papyrus.infra.emf.internal.resource.InternalIndexUtil;
import org.eclipse.papyrus.infra.emf.resource.ICrossReferenceIndex;

public class ShardResourceLocator
extends ResourceSetImpl.ResourceLocator {
    private final Set<Resource> inDemandLoadHelper = new HashSet<Resource>();
    private final Supplier<? extends ICrossReferenceIndex> index;
    private final Set<String> semanticModelExtensions;

    public ShardResourceLocator(ResourceSetImpl resourceSet) {
        this(resourceSet, new ICrossReferenceIndex.Delegator((ResourceSet)resourceSet));
    }

    public ShardResourceLocator(ResourceSetImpl resourceSet, ICrossReferenceIndex index) {
        this(resourceSet, () -> index);
    }

    public ShardResourceLocator(ResourceSetImpl resourceSet, Supplier<? extends ICrossReferenceIndex> index) {
        super(resourceSet);
        this.index = index;
        this.semanticModelExtensions = InternalIndexUtil.getSemanticModelFileExtensions((ResourceSet)resourceSet);
    }

    public Resource getResource(URI uri, boolean loadOnDemand) {
        Resource existing;
        if (loadOnDemand && uri.isPlatformResource() && this.semanticModelExtensions.contains(uri.fileExtension()) && ((existing = this.getResource(uri, false)) == null || !existing.isLoaded())) {
            this.handleShard(uri);
        }
        return this.basicGetResource(uri, loadOnDemand);
    }

    protected void handleShard(URI uri) {
        try {
            Set<URI> parents = this.index.get().getParents(uri);
            if (!parents.isEmpty()) {
                parents.stream().filter(this::notLoaded).forEach(r -> this.loadParentResource((URI)r, uri));
            }
        }
        catch (CoreException e) {
            Activator.log.log(e.getStatus());
        }
    }

    protected boolean notLoaded(URI uri) {
        Resource resource = this.resourceSet.getResource(uri, false);
        return resource == null || !resource.isLoaded();
    }

    protected void loadParentResource(URI parentURI, URI shardURI) {
        Resource parent = this.resourceSet.getResource(parentURI, true);
        Resource shard = this.resourceSet.getResource(shardURI, true);
        this.inDemandLoadHelper.remove(shard);
        URI normalizedShardURI = this.normalize(shardURI);
        TreeIterator iter = EcoreUtil.getAllProperContents((Resource)parent, (boolean)false);
        while (iter.hasNext()) {
            URI proxyURI;
            EObject next = (EObject)iter.next();
            if (!next.eIsProxy() || !(proxyURI = this.normalize(((InternalEObject)next).eProxyURI())).trimFragment().equals(normalizedShardURI)) continue;
            EObject parentObject = next.eContainer();
            EReference containment = next.eContainmentFeature();
            if (!containment.isMany()) {
                parentObject.eGet((EStructuralFeature)containment, true);
                break;
            }
            InternalEList list = (InternalEList)parentObject.eGet((EStructuralFeature)containment);
            int index = list.basicIndexOf((Object)next);
            if (index < 0) break;
            list.get(index);
            break;
        }
    }

    protected URI normalize(URI uri) {
        return this.resourceSet.getURIConverter().normalize(uri);
    }
}

