/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.elementtypes.internal.checkers;

import java.util.Collection;
import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.CustomModelChecker;
import org.eclipse.papyrus.toolsmiths.validation.common.utils.LocalProfileIndex;
import org.eclipse.papyrus.toolsmiths.validation.elementtypes.internal.messages.Messages;
import org.eclipse.papyrus.uml.types.core.advices.applystereotype.FeatureToSet;
import org.eclipse.papyrus.uml.types.core.advices.applystereotype.StereotypeToApply;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Stereotype;

public class ApplyStereotypeAdviceCustomValidator
extends CustomModelChecker.SwitchValidator {
    public ApplyStereotypeAdviceCustomValidator(String nsURI) {
        super(nsURI);
    }

    public void validate(StereotypeToApply stereotypeToApply, DiagnosticChain diagnostics, Map<Object, Object> context) {
        for (String profileQualifiedName : stereotypeToApply.getRequiredProfiles()) {
            this.validateRequiredProfile(stereotypeToApply, profileQualifiedName, diagnostics, context);
        }
        if (stereotypeToApply.getStereotypeQualifiedName() != null) {
            this.validateStereotypeName(stereotypeToApply, stereotypeToApply.getStereotypeQualifiedName(), diagnostics, context);
        }
    }

    private void validateRequiredProfile(StereotypeToApply stereotypeToApply, String profileQualifiedName, DiagnosticChain diagnostics, Map<Object, Object> context) {
        LocalProfileIndex index = LocalProfileIndex.getInstance((EObject)stereotypeToApply, context);
        Profile profile = index.getProfile(profileQualifiedName, (EObject)stereotypeToApply);
        if (profile == null) {
            diagnostics.add(this.createDiagnostic(4, (EObject)stereotypeToApply, this.format(Messages.ApplyStereotypeAdviceCustomValidator_0, context, new Object[]{stereotypeToApply, profileQualifiedName})));
        }
    }

    private void validateStereotypeName(StereotypeToApply stereotypeToApply, String qualifiedName, DiagnosticChain diagnostics, Map<Object, Object> context) {
        Stereotype stereotype = this.getStereotype(stereotypeToApply, context);
        if (stereotype == null) {
            diagnostics.add(this.createDiagnostic(4, (EObject)stereotypeToApply, this.format(Messages.ApplyStereotypeAdviceCustomValidator_1, context, new Object[]{stereotypeToApply})));
        }
    }

    private Stereotype getStereotype(StereotypeToApply stereotypeToApply, Map<Object, Object> context) {
        LocalProfileIndex index = LocalProfileIndex.getInstance((EObject)stereotypeToApply, context);
        return index.getStereotype(stereotypeToApply.getStereotypeQualifiedName(), (Collection)stereotypeToApply.getRequiredProfiles(), (EObject)stereotypeToApply);
    }

    public void validate(FeatureToSet featureToSet, DiagnosticChain diagnostics, Map<Object, Object> context) {
        String featureName;
        if (!(featureToSet.eContainer() instanceof StereotypeToApply)) {
            diagnostics.add(this.createDiagnostic(4, (EObject)featureToSet, this.format(Messages.ApplyStereotypeAdviceCustomValidator_2, context, new Object[]{featureToSet})));
            return;
        }
        Stereotype stereotype = this.getStereotype((StereotypeToApply)featureToSet.eContainer(), context);
        if (stereotype != null && stereotype.getFeature(featureName = featureToSet.getFeatureName()) == null) {
            diagnostics.add(this.createDiagnostic(4, (EObject)featureToSet, this.format(Messages.ApplyStereotypeAdviceCustomValidator_3, context, new Object[]{featureName, featureToSet})));
        }
    }
}

