/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.junit.utils;

import java.lang.reflect.Field;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.infra.core.resource.IReadOnlyHandler2;
import org.eclipse.papyrus.infra.core.resource.ModelMultiException;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.ReadOnlyAxis;
import org.eclipse.papyrus.infra.core.utils.DiResourceSet;
import org.eclipse.papyrus.junit.utils.Duck;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class ModelUtils {
    public static ModelSet loadModelSet(URI uri, boolean resolveAll) throws ModelMultiException {
        DiResourceSet modelSet = new DiResourceSet();
        TransactionalEditingDomain.Factory.INSTANCE.createEditingDomain((ResourceSet)modelSet);
        modelSet.loadModels(uri);
        if (resolveAll) {
            EcoreUtil.resolveAll((ResourceSet)modelSet);
        }
        return modelSet;
    }

    public static ModelSet loadModelSet(IPath workspacePath, boolean resolveAll) throws ModelMultiException {
        URI workspaceURI = URI.createPlatformResourceURI((String)workspacePath.toString(), (boolean)true);
        return ModelUtils.loadModelSet(workspaceURI, resolveAll);
    }

    public static TransactionalEditingDomain getEditingDomain(ModelSet modelSet) {
        return TransactionalEditingDomain.Factory.INSTANCE.getEditingDomain((ResourceSet)modelSet);
    }

    public static void makeReferencedModelsWritable(ModelSet modelSet, URI ... uris) {
        IReadOnlyHandler2 handler = modelSet.getReadOnlyHandler();
        if (handler != null) {
            try {
                Field orderedHandlersByAxisField = handler.getClass().getDeclaredField("orderedHandlersByAxis");
                orderedHandlersByAxisField.setAccessible(true);
                Map orderedHandlersByAxis = (Map)orderedHandlersByAxisField.get(handler);
                IReadOnlyHandler2[] iReadOnlyHandler2Array = (IReadOnlyHandler2[])orderedHandlersByAxis.get(ReadOnlyAxis.DISCRETION);
                int n = iReadOnlyHandler2Array.length;
                int n2 = 0;
                while (n2 < n) {
                    IReadOnlyHandler2 next = iReadOnlyHandler2Array[n2];
                    Duck nextHandler = new Duck(next);
                    if (nextHandler.understands("setInteractive", false)) {
                        nextHandler.quack("setInteractive", false);
                    }
                    if (((Boolean)next.canMakeWritable(ReadOnlyAxis.discretionAxes(), uris).or((Object)false)).booleanValue()) {
                        next.makeWritable(ReadOnlyAxis.discretionAxes(), uris);
                    }
                    ++n2;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            Assert.assertThat((String)("Could not make referenced models writable: " + String.valueOf(uris)), (Object)((Boolean)handler.anyReadOnly(ReadOnlyAxis.discretionAxes(), uris).or((Object)true)), (Matcher)CoreMatchers.is((Object)false));
        }
    }
}

