/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.edit.editor;

import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;

public class ControlDecorationProvider {
    private String fieldDecorationId;
    private boolean errorDecorationEnabled;
    private ControlDecoration errorDecoration;
    private String errorDecorationText;
    private int decorationPositionOverride = -1;

    public ControlDecorationProvider() {
        this("DEC_ERROR");
    }

    public ControlDecorationProvider(String fieldDecorationId) {
        this.fieldDecorationId = fieldDecorationId;
    }

    public void setErrorDecorationEnabled(boolean enabled) {
        this.errorDecorationEnabled = enabled;
    }

    public void setErrorDecorationText(String errorText) {
        this.errorDecorationText = errorText;
        if (this.errorDecoration != null) {
            this.errorDecoration.setDescriptionText(errorText);
        }
    }

    public void showErrorDecorationHover(String errorText) {
        if (this.errorDecoration != null) {
            this.errorDecoration.show();
            this.errorDecoration.showHoverText(errorText);
        }
    }

    public void setFieldDecorationId(String fieldDecorationId) {
        this.fieldDecorationId = fieldDecorationId;
    }

    public void setDecorationPositionOverride(int decorationPositionOverride) {
        this.decorationPositionOverride = decorationPositionOverride;
    }

    public void showDecoration() {
        if (this.errorDecoration != null) {
            this.errorDecoration.show();
        }
    }

    public void hideDecoration() {
        if (this.errorDecoration != null) {
            this.errorDecoration.hide();
        }
    }

    public void dispose() {
        if (this.errorDecoration != null) {
            this.errorDecoration.hide();
            this.errorDecoration.dispose();
            this.errorDecoration = null;
        }
    }

    public void createErrorDecorationIfRequired(final Control controlToDecorate) {
        if (this.errorDecorationEnabled) {
            final Image errorImage = FieldDecorationRegistry.getDefault().getFieldDecoration(this.fieldDecorationId).getImage();
            if (this.decorationPositionOverride == -1) {
                controlToDecorate.addPaintListener(new PaintListener(){

                    public void paintControl(PaintEvent e) {
                        controlToDecorate.removePaintListener((PaintListener)this);
                        int position = 128;
                        Rectangle textBounds = controlToDecorate.getBounds();
                        Rectangle parentClientArea = controlToDecorate.getParent().getClientArea();
                        position = parentClientArea.x + parentClientArea.width > textBounds.x + textBounds.width + errorImage.getBounds().width ? (position |= 0x20000) : (position |= 0x4000);
                        ControlDecorationProvider.this.errorDecoration = ControlDecorationProvider.this.newControlDecoration(controlToDecorate, errorImage, position);
                    }
                });
            } else {
                this.errorDecoration = this.newControlDecoration(controlToDecorate, errorImage, this.decorationPositionOverride);
            }
        }
    }

    private ControlDecoration newControlDecoration(Control controlToDecorate, Image errorImage, int position) {
        ControlDecoration errorDecoration = new ControlDecoration(controlToDecorate, position);
        errorDecoration.setImage(errorImage);
        errorDecoration.setDescriptionText(this.errorDecorationText);
        errorDecoration.hide();
        return errorDecoration;
    }
}

