/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.editors.richtext;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.nebula.widgets.richtext.RichTextEditorConfiguration;
import org.eclipse.nebula.widgets.richtext.toolbar.ToolbarButton;
import org.eclipse.papyrus.infra.widgets.editors.richtext.AbstractToolbarButton;
import org.eclipse.papyrus.infra.widgets.editors.richtext.GenericRichTextEditor;
import org.eclipse.papyrus.infra.widgets.editors.richtext.SpellCheckToolbarButton;
import org.eclipse.swt.browser.BrowserFunction;

public class GenericRichTextEditorConfiguration
extends RichTextEditorConfiguration {
    private List<AbstractToolbarButton> buttons = new ArrayList<AbstractToolbarButton>();

    public GenericRichTextEditorConfiguration() {
        this.removeDefaultToolbarButton();
        this.registerDefaultButton();
    }

    protected void removeDefaultToolbarButton() {
        this.removeDefaultToolbarButton(new String[]{"Flash"});
        this.removeDefaultToolbarButton(new String[]{"Table"});
        this.removeDefaultToolbarButton(new String[]{"HorizontalRule"});
        this.removeDefaultToolbarButton(new String[]{"Smiley"});
        this.removeDefaultToolbarButton(new String[]{"SpecialChar"});
        this.removeDefaultToolbarButton(new String[]{"PageBreak"});
        this.removeDefaultToolbarButton(new String[]{"Iframe"});
    }

    protected void registerDefaultButton() {
        this.addSpellCheckToolbarButton();
    }

    protected void addSpellCheckToolbarButton() {
        SpellCheckToolbarButton action = new SpellCheckToolbarButton();
        this.addToolbarButton(action);
    }

    public void addToolbarButton(ToolbarButton button, BrowserFunction function) {
        if (button instanceof AbstractToolbarButton) {
            this.buttons.add((AbstractToolbarButton)button);
        }
        super.addToolbarButton(button, function);
    }

    public void setRichTextEditor(GenericRichTextEditor editor) {
        for (AbstractToolbarButton current : this.buttons) {
            current.setRichTextEditor(editor);
        }
    }
}

