/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.tester;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.papyrus.infra.nattable.Activator;
import org.eclipse.papyrus.infra.nattable.messages.Messages;
import org.eclipse.papyrus.infra.nattable.tester.ITableTester;

public class TableTesterRegistry {
    private static final String EXTENSION_ID = "org.eclipse.papyrus.infra.nattable.tester";
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String ID_ATTRIBUTE = "id";
    private Map<String, ITableTester> testers;
    public static final TableTesterRegistry INSTANCE = new TableTesterRegistry();

    private TableTesterRegistry() {
    }

    public ITableTester getTableTester(String testerId) {
        if (this.testers == null) {
            IConfigurationElement[] configElements;
            this.testers = new HashMap<String, ITableTester>();
            IConfigurationElement[] iConfigurationElementArray = configElements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_ID);
            int n = configElements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
                String id = iConfigurationElement.getAttribute(ID_ATTRIBUTE);
                if (this.testers.containsKey(id)) {
                    Activator.log.warn(String.format(Messages.TableTesterRegistry_SeveralTesterAreRegisteredWithTheSameId, id));
                } else {
                    ITableTester tester = null;
                    try {
                        tester = (ITableTester)iConfigurationElement.createExecutableExtension(CLASS_ATTRIBUTE);
                        this.testers.put(id, tester);
                    }
                    catch (CoreException e) {
                        Activator.log.error(String.format(Messages.TableTesterRegistry_TheClassCantBeLoaded, id), (Throwable)e);
                    }
                }
                ++n2;
            }
        }
        return this.testers.get(testerId);
    }
}

